/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotthingsgraph.model.DefinitionDocument;
import com.amazonaws.services.iotthingsgraph.model.DependencyRevision;
import com.amazonaws.services.iotthingsgraph.model.MetricsConfiguration;
import com.amazonaws.services.iotthingsgraph.model.SystemInstanceSummary;
import com.amazonaws.services.iotthingsgraph.model.transform.SystemInstanceDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SystemInstanceDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private SystemInstanceSummary summary;
    private DefinitionDocument definition;
    private String s3BucketName;
    private MetricsConfiguration metricsConfiguration;
    private Long validatedNamespaceVersion;
    private List<DependencyRevision> validatedDependencyRevisions;
    private String flowActionsRoleArn;

    public void setSummary(SystemInstanceSummary summary) {
        this.summary = summary;
    }

    public SystemInstanceSummary getSummary() {
        return this.summary;
    }

    public SystemInstanceDescription withSummary(SystemInstanceSummary summary) {
        this.setSummary(summary);
        return this;
    }

    public void setDefinition(DefinitionDocument definition) {
        this.definition = definition;
    }

    public DefinitionDocument getDefinition() {
        return this.definition;
    }

    public SystemInstanceDescription withDefinition(DefinitionDocument definition) {
        this.setDefinition(definition);
        return this;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public SystemInstanceDescription withS3BucketName(String s3BucketName) {
        this.setS3BucketName(s3BucketName);
        return this;
    }

    public void setMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.metricsConfiguration = metricsConfiguration;
    }

    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public SystemInstanceDescription withMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.setMetricsConfiguration(metricsConfiguration);
        return this;
    }

    public void setValidatedNamespaceVersion(Long validatedNamespaceVersion) {
        this.validatedNamespaceVersion = validatedNamespaceVersion;
    }

    public Long getValidatedNamespaceVersion() {
        return this.validatedNamespaceVersion;
    }

    public SystemInstanceDescription withValidatedNamespaceVersion(Long validatedNamespaceVersion) {
        this.setValidatedNamespaceVersion(validatedNamespaceVersion);
        return this;
    }

    public List<DependencyRevision> getValidatedDependencyRevisions() {
        return this.validatedDependencyRevisions;
    }

    public void setValidatedDependencyRevisions(Collection<DependencyRevision> validatedDependencyRevisions) {
        if (validatedDependencyRevisions == null) {
            this.validatedDependencyRevisions = null;
            return;
        }
        this.validatedDependencyRevisions = new ArrayList<DependencyRevision>(validatedDependencyRevisions);
    }

    public SystemInstanceDescription withValidatedDependencyRevisions(DependencyRevision ... validatedDependencyRevisions) {
        if (this.validatedDependencyRevisions == null) {
            this.setValidatedDependencyRevisions(new ArrayList<DependencyRevision>(validatedDependencyRevisions.length));
        }
        for (DependencyRevision ele : validatedDependencyRevisions) {
            this.validatedDependencyRevisions.add(ele);
        }
        return this;
    }

    public SystemInstanceDescription withValidatedDependencyRevisions(Collection<DependencyRevision> validatedDependencyRevisions) {
        this.setValidatedDependencyRevisions(validatedDependencyRevisions);
        return this;
    }

    public void setFlowActionsRoleArn(String flowActionsRoleArn) {
        this.flowActionsRoleArn = flowActionsRoleArn;
    }

    public String getFlowActionsRoleArn() {
        return this.flowActionsRoleArn;
    }

    public SystemInstanceDescription withFlowActionsRoleArn(String flowActionsRoleArn) {
        this.setFlowActionsRoleArn(flowActionsRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition()).append(",");
        }
        if (this.getS3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.getS3BucketName()).append(",");
        }
        if (this.getMetricsConfiguration() != null) {
            sb.append("MetricsConfiguration: ").append(this.getMetricsConfiguration()).append(",");
        }
        if (this.getValidatedNamespaceVersion() != null) {
            sb.append("ValidatedNamespaceVersion: ").append(this.getValidatedNamespaceVersion()).append(",");
        }
        if (this.getValidatedDependencyRevisions() != null) {
            sb.append("ValidatedDependencyRevisions: ").append(this.getValidatedDependencyRevisions()).append(",");
        }
        if (this.getFlowActionsRoleArn() != null) {
            sb.append("FlowActionsRoleArn: ").append(this.getFlowActionsRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInstanceDescription)) {
            return false;
        }
        SystemInstanceDescription other = (SystemInstanceDescription)obj;
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getS3BucketName() == null ^ this.getS3BucketName() == null) {
            return false;
        }
        if (other.getS3BucketName() != null && !other.getS3BucketName().equals(this.getS3BucketName())) {
            return false;
        }
        if (other.getMetricsConfiguration() == null ^ this.getMetricsConfiguration() == null) {
            return false;
        }
        if (other.getMetricsConfiguration() != null && !other.getMetricsConfiguration().equals(this.getMetricsConfiguration())) {
            return false;
        }
        if (other.getValidatedNamespaceVersion() == null ^ this.getValidatedNamespaceVersion() == null) {
            return false;
        }
        if (other.getValidatedNamespaceVersion() != null && !other.getValidatedNamespaceVersion().equals(this.getValidatedNamespaceVersion())) {
            return false;
        }
        if (other.getValidatedDependencyRevisions() == null ^ this.getValidatedDependencyRevisions() == null) {
            return false;
        }
        if (other.getValidatedDependencyRevisions() != null && !other.getValidatedDependencyRevisions().equals(this.getValidatedDependencyRevisions())) {
            return false;
        }
        if (other.getFlowActionsRoleArn() == null ^ this.getFlowActionsRoleArn() == null) {
            return false;
        }
        return other.getFlowActionsRoleArn() == null || other.getFlowActionsRoleArn().equals(this.getFlowActionsRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getS3BucketName() == null ? 0 : this.getS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricsConfiguration() == null ? 0 : this.getMetricsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getValidatedNamespaceVersion() == null ? 0 : this.getValidatedNamespaceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getValidatedDependencyRevisions() == null ? 0 : this.getValidatedDependencyRevisions().hashCode());
        hashCode = 31 * hashCode + (this.getFlowActionsRoleArn() == null ? 0 : this.getFlowActionsRoleArn().hashCode());
        return hashCode;
    }

    public SystemInstanceDescription clone() {
        try {
            return (SystemInstanceDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SystemInstanceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

