/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotsitewise.model.ErrorReportLocation;
import com.amazonaws.services.iotsitewise.model.File;
import com.amazonaws.services.iotsitewise.model.JobConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateBulkImportJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobName;
    private String jobRoleArn;
    private List<File> files;
    private ErrorReportLocation errorReportLocation;
    private JobConfiguration jobConfiguration;
    private Boolean adaptiveIngestion;
    private Boolean deleteFilesAfterImport;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public CreateBulkImportJobRequest withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setJobRoleArn(String jobRoleArn) {
        this.jobRoleArn = jobRoleArn;
    }

    public String getJobRoleArn() {
        return this.jobRoleArn;
    }

    public CreateBulkImportJobRequest withJobRoleArn(String jobRoleArn) {
        this.setJobRoleArn(jobRoleArn);
        return this;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(Collection<File> files) {
        if (files == null) {
            this.files = null;
            return;
        }
        this.files = new ArrayList<File>(files);
    }

    public CreateBulkImportJobRequest withFiles(File ... files) {
        if (this.files == null) {
            this.setFiles(new ArrayList<File>(files.length));
        }
        for (File ele : files) {
            this.files.add(ele);
        }
        return this;
    }

    public CreateBulkImportJobRequest withFiles(Collection<File> files) {
        this.setFiles(files);
        return this;
    }

    public void setErrorReportLocation(ErrorReportLocation errorReportLocation) {
        this.errorReportLocation = errorReportLocation;
    }

    public ErrorReportLocation getErrorReportLocation() {
        return this.errorReportLocation;
    }

    public CreateBulkImportJobRequest withErrorReportLocation(ErrorReportLocation errorReportLocation) {
        this.setErrorReportLocation(errorReportLocation);
        return this;
    }

    public void setJobConfiguration(JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    public JobConfiguration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public CreateBulkImportJobRequest withJobConfiguration(JobConfiguration jobConfiguration) {
        this.setJobConfiguration(jobConfiguration);
        return this;
    }

    public void setAdaptiveIngestion(Boolean adaptiveIngestion) {
        this.adaptiveIngestion = adaptiveIngestion;
    }

    public Boolean getAdaptiveIngestion() {
        return this.adaptiveIngestion;
    }

    public CreateBulkImportJobRequest withAdaptiveIngestion(Boolean adaptiveIngestion) {
        this.setAdaptiveIngestion(adaptiveIngestion);
        return this;
    }

    public Boolean isAdaptiveIngestion() {
        return this.adaptiveIngestion;
    }

    public void setDeleteFilesAfterImport(Boolean deleteFilesAfterImport) {
        this.deleteFilesAfterImport = deleteFilesAfterImport;
    }

    public Boolean getDeleteFilesAfterImport() {
        return this.deleteFilesAfterImport;
    }

    public CreateBulkImportJobRequest withDeleteFilesAfterImport(Boolean deleteFilesAfterImport) {
        this.setDeleteFilesAfterImport(deleteFilesAfterImport);
        return this;
    }

    public Boolean isDeleteFilesAfterImport() {
        return this.deleteFilesAfterImport;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getJobRoleArn() != null) {
            sb.append("JobRoleArn: ").append(this.getJobRoleArn()).append(",");
        }
        if (this.getFiles() != null) {
            sb.append("Files: ").append(this.getFiles()).append(",");
        }
        if (this.getErrorReportLocation() != null) {
            sb.append("ErrorReportLocation: ").append(this.getErrorReportLocation()).append(",");
        }
        if (this.getJobConfiguration() != null) {
            sb.append("JobConfiguration: ").append(this.getJobConfiguration()).append(",");
        }
        if (this.getAdaptiveIngestion() != null) {
            sb.append("AdaptiveIngestion: ").append(this.getAdaptiveIngestion()).append(",");
        }
        if (this.getDeleteFilesAfterImport() != null) {
            sb.append("DeleteFilesAfterImport: ").append(this.getDeleteFilesAfterImport());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBulkImportJobRequest)) {
            return false;
        }
        CreateBulkImportJobRequest other = (CreateBulkImportJobRequest)obj;
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getJobRoleArn() == null ^ this.getJobRoleArn() == null) {
            return false;
        }
        if (other.getJobRoleArn() != null && !other.getJobRoleArn().equals(this.getJobRoleArn())) {
            return false;
        }
        if (other.getFiles() == null ^ this.getFiles() == null) {
            return false;
        }
        if (other.getFiles() != null && !other.getFiles().equals(this.getFiles())) {
            return false;
        }
        if (other.getErrorReportLocation() == null ^ this.getErrorReportLocation() == null) {
            return false;
        }
        if (other.getErrorReportLocation() != null && !other.getErrorReportLocation().equals(this.getErrorReportLocation())) {
            return false;
        }
        if (other.getJobConfiguration() == null ^ this.getJobConfiguration() == null) {
            return false;
        }
        if (other.getJobConfiguration() != null && !other.getJobConfiguration().equals(this.getJobConfiguration())) {
            return false;
        }
        if (other.getAdaptiveIngestion() == null ^ this.getAdaptiveIngestion() == null) {
            return false;
        }
        if (other.getAdaptiveIngestion() != null && !other.getAdaptiveIngestion().equals(this.getAdaptiveIngestion())) {
            return false;
        }
        if (other.getDeleteFilesAfterImport() == null ^ this.getDeleteFilesAfterImport() == null) {
            return false;
        }
        return other.getDeleteFilesAfterImport() == null || other.getDeleteFilesAfterImport().equals(this.getDeleteFilesAfterImport());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getJobRoleArn() == null ? 0 : this.getJobRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getFiles() == null ? 0 : this.getFiles().hashCode());
        hashCode = 31 * hashCode + (this.getErrorReportLocation() == null ? 0 : this.getErrorReportLocation().hashCode());
        hashCode = 31 * hashCode + (this.getJobConfiguration() == null ? 0 : this.getJobConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAdaptiveIngestion() == null ? 0 : this.getAdaptiveIngestion().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteFilesAfterImport() == null ? 0 : this.getDeleteFilesAfterImport().hashCode());
        return hashCode;
    }

    public CreateBulkImportJobRequest clone() {
        return (CreateBulkImportJobRequest)super.clone();
    }
}

