/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.Quality;
import com.amazonaws.services.iotsitewise.model.TimeInNanos;
import com.amazonaws.services.iotsitewise.model.Variant;
import com.amazonaws.services.iotsitewise.model.transform.AssetPropertyValueMarshaller;
import java.io.Serializable;

public class AssetPropertyValue
implements Serializable,
Cloneable,
StructuredPojo {
    private Variant value;
    private TimeInNanos timestamp;
    private String quality;

    public void setValue(Variant value) {
        this.value = value;
    }

    public Variant getValue() {
        return this.value;
    }

    public AssetPropertyValue withValue(Variant value) {
        this.setValue(value);
        return this;
    }

    public void setTimestamp(TimeInNanos timestamp) {
        this.timestamp = timestamp;
    }

    public TimeInNanos getTimestamp() {
        return this.timestamp;
    }

    public AssetPropertyValue withTimestamp(TimeInNanos timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getQuality() {
        return this.quality;
    }

    public AssetPropertyValue withQuality(String quality) {
        this.setQuality(quality);
        return this;
    }

    public AssetPropertyValue withQuality(Quality quality) {
        this.quality = quality.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getQuality() != null) {
            sb.append("Quality: ").append(this.getQuality());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyValue)) {
            return false;
        }
        AssetPropertyValue other = (AssetPropertyValue)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getQuality() == null ^ this.getQuality() == null) {
            return false;
        }
        return other.getQuality() == null || other.getQuality().equals(this.getQuality());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getQuality() == null ? 0 : this.getQuality().hashCode());
        return hashCode;
    }

    public AssetPropertyValue clone() {
        try {
            return (AssetPropertyValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssetPropertyValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

