/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.ImageFileType;
import com.amazonaws.services.iotsitewise.model.transform.ImageFileMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ImageFile
implements Serializable,
Cloneable,
StructuredPojo {
    private ByteBuffer encodedString;
    private String fileType;

    public void setEncodedString(ByteBuffer encodedString) {
        this.encodedString = encodedString;
    }

    public ByteBuffer getEncodedString() {
        return this.encodedString;
    }

    public ImageFile withEncodedString(ByteBuffer encodedString) {
        this.setEncodedString(encodedString);
        return this;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public ImageFile withFileType(String fileType) {
        this.setFileType(fileType);
        return this;
    }

    public ImageFile withFileType(ImageFileType fileType) {
        this.fileType = fileType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncodedString() != null) {
            sb.append("EncodedString: ").append(this.getEncodedString()).append(",");
        }
        if (this.getFileType() != null) {
            sb.append("FileType: ").append(this.getFileType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageFile)) {
            return false;
        }
        ImageFile other = (ImageFile)obj;
        if (other.getEncodedString() == null ^ this.getEncodedString() == null) {
            return false;
        }
        if (other.getEncodedString() != null && !other.getEncodedString().equals(this.getEncodedString())) {
            return false;
        }
        if (other.getFileType() == null ^ this.getFileType() == null) {
            return false;
        }
        return other.getFileType() == null || other.getFileType().equals(this.getFileType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncodedString() == null ? 0 : this.getEncodedString().hashCode());
        hashCode = 31 * hashCode + (this.getFileType() == null ? 0 : this.getFileType().hashCode());
        return hashCode;
    }

    public ImageFile clone() {
        try {
            return (ImageFile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageFileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

