/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotjobsdataplane;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotjobsdataplane.AWSIoTJobsDataPlaneAsync;
import com.amazonaws.services.iotjobsdataplane.AWSIoTJobsDataPlaneAsyncClientBuilder;
import com.amazonaws.services.iotjobsdataplane.AWSIoTJobsDataPlaneClient;
import com.amazonaws.services.iotjobsdataplane.model.DescribeJobExecutionRequest;
import com.amazonaws.services.iotjobsdataplane.model.DescribeJobExecutionResult;
import com.amazonaws.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest;
import com.amazonaws.services.iotjobsdataplane.model.GetPendingJobExecutionsResult;
import com.amazonaws.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest;
import com.amazonaws.services.iotjobsdataplane.model.StartNextPendingJobExecutionResult;
import com.amazonaws.services.iotjobsdataplane.model.UpdateJobExecutionRequest;
import com.amazonaws.services.iotjobsdataplane.model.UpdateJobExecutionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTJobsDataPlaneAsyncClient
extends AWSIoTJobsDataPlaneClient
implements AWSIoTJobsDataPlaneAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTJobsDataPlaneAsyncClientBuilder asyncBuilder() {
        return AWSIoTJobsDataPlaneAsyncClientBuilder.standard();
    }

    AWSIoTJobsDataPlaneAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeJobExecutionResult> describeJobExecutionAsync(DescribeJobExecutionRequest request) {
        return this.describeJobExecutionAsync(request, null);
    }

    @Override
    public Future<DescribeJobExecutionResult> describeJobExecutionAsync(DescribeJobExecutionRequest request, final AsyncHandler<DescribeJobExecutionRequest, DescribeJobExecutionResult> asyncHandler) {
        final DescribeJobExecutionRequest finalRequest = (DescribeJobExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobExecutionResult>(){

            @Override
            public DescribeJobExecutionResult call() throws Exception {
                DescribeJobExecutionResult result = null;
                try {
                    result = AWSIoTJobsDataPlaneAsyncClient.this.executeDescribeJobExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPendingJobExecutionsResult> getPendingJobExecutionsAsync(GetPendingJobExecutionsRequest request) {
        return this.getPendingJobExecutionsAsync(request, null);
    }

    @Override
    public Future<GetPendingJobExecutionsResult> getPendingJobExecutionsAsync(GetPendingJobExecutionsRequest request, final AsyncHandler<GetPendingJobExecutionsRequest, GetPendingJobExecutionsResult> asyncHandler) {
        final GetPendingJobExecutionsRequest finalRequest = (GetPendingJobExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPendingJobExecutionsResult>(){

            @Override
            public GetPendingJobExecutionsResult call() throws Exception {
                GetPendingJobExecutionsResult result = null;
                try {
                    result = AWSIoTJobsDataPlaneAsyncClient.this.executeGetPendingJobExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartNextPendingJobExecutionResult> startNextPendingJobExecutionAsync(StartNextPendingJobExecutionRequest request) {
        return this.startNextPendingJobExecutionAsync(request, null);
    }

    @Override
    public Future<StartNextPendingJobExecutionResult> startNextPendingJobExecutionAsync(StartNextPendingJobExecutionRequest request, final AsyncHandler<StartNextPendingJobExecutionRequest, StartNextPendingJobExecutionResult> asyncHandler) {
        final StartNextPendingJobExecutionRequest finalRequest = (StartNextPendingJobExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartNextPendingJobExecutionResult>(){

            @Override
            public StartNextPendingJobExecutionResult call() throws Exception {
                StartNextPendingJobExecutionResult result = null;
                try {
                    result = AWSIoTJobsDataPlaneAsyncClient.this.executeStartNextPendingJobExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobExecutionResult> updateJobExecutionAsync(UpdateJobExecutionRequest request) {
        return this.updateJobExecutionAsync(request, null);
    }

    @Override
    public Future<UpdateJobExecutionResult> updateJobExecutionAsync(UpdateJobExecutionRequest request, final AsyncHandler<UpdateJobExecutionRequest, UpdateJobExecutionResult> asyncHandler) {
        final UpdateJobExecutionRequest finalRequest = (UpdateJobExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobExecutionResult>(){

            @Override
            public UpdateJobExecutionResult call() throws Exception {
                UpdateJobExecutionResult result = null;
                try {
                    result = AWSIoTJobsDataPlaneAsyncClient.this.executeUpdateJobExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

