/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotfleetwise.model.NodeDataType;
import com.amazonaws.services.iotfleetwise.model.transform.SensorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Sensor
implements Serializable,
Cloneable,
StructuredPojo {
    private String fullyQualifiedName;
    private String dataType;
    private String description;
    private String unit;
    private List<String> allowedValues;
    private Double min;
    private Double max;

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public Sensor withFullyQualifiedName(String fullyQualifiedName) {
        this.setFullyQualifiedName(fullyQualifiedName);
        return this;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Sensor withDataType(String dataType) {
        this.setDataType(dataType);
        return this;
    }

    public Sensor withDataType(NodeDataType dataType) {
        this.dataType = dataType.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Sensor withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public Sensor withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Collection<String> allowedValues) {
        if (allowedValues == null) {
            this.allowedValues = null;
            return;
        }
        this.allowedValues = new ArrayList<String>(allowedValues);
    }

    public Sensor withAllowedValues(String ... allowedValues) {
        if (this.allowedValues == null) {
            this.setAllowedValues(new ArrayList<String>(allowedValues.length));
        }
        for (String ele : allowedValues) {
            this.allowedValues.add(ele);
        }
        return this;
    }

    public Sensor withAllowedValues(Collection<String> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public Double getMin() {
        return this.min;
    }

    public Sensor withMin(Double min) {
        this.setMin(min);
        return this;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public Double getMax() {
        return this.max;
    }

    public Sensor withMax(Double max) {
        this.setMax(max);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFullyQualifiedName() != null) {
            sb.append("FullyQualifiedName: ").append(this.getFullyQualifiedName()).append(",");
        }
        if (this.getDataType() != null) {
            sb.append("DataType: ").append(this.getDataType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit()).append(",");
        }
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues()).append(",");
        }
        if (this.getMin() != null) {
            sb.append("Min: ").append(this.getMin()).append(",");
        }
        if (this.getMax() != null) {
            sb.append("Max: ").append(this.getMax());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sensor)) {
            return false;
        }
        Sensor other = (Sensor)obj;
        if (other.getFullyQualifiedName() == null ^ this.getFullyQualifiedName() == null) {
            return false;
        }
        if (other.getFullyQualifiedName() != null && !other.getFullyQualifiedName().equals(this.getFullyQualifiedName())) {
            return false;
        }
        if (other.getDataType() == null ^ this.getDataType() == null) {
            return false;
        }
        if (other.getDataType() != null && !other.getDataType().equals(this.getDataType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        if (other.getAllowedValues() != null && !other.getAllowedValues().equals(this.getAllowedValues())) {
            return false;
        }
        if (other.getMin() == null ^ this.getMin() == null) {
            return false;
        }
        if (other.getMin() != null && !other.getMin().equals(this.getMin())) {
            return false;
        }
        if (other.getMax() == null ^ this.getMax() == null) {
            return false;
        }
        return other.getMax() == null || other.getMax().equals(this.getMax());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFullyQualifiedName() == null ? 0 : this.getFullyQualifiedName().hashCode());
        hashCode = 31 * hashCode + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMin() == null ? 0 : this.getMin().hashCode());
        hashCode = 31 * hashCode + (this.getMax() == null ? 0 : this.getMax().hashCode());
        return hashCode;
    }

    public Sensor clone() {
        try {
            return (Sensor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SensorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

