/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotevents.model.RecipientDetail;
import com.amazonaws.services.iotevents.model.transform.SMSConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SMSConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String senderId;
    private String additionalMessage;
    private List<RecipientDetail> recipients;

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public SMSConfiguration withSenderId(String senderId) {
        this.setSenderId(senderId);
        return this;
    }

    public void setAdditionalMessage(String additionalMessage) {
        this.additionalMessage = additionalMessage;
    }

    public String getAdditionalMessage() {
        return this.additionalMessage;
    }

    public SMSConfiguration withAdditionalMessage(String additionalMessage) {
        this.setAdditionalMessage(additionalMessage);
        return this;
    }

    public List<RecipientDetail> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Collection<RecipientDetail> recipients) {
        if (recipients == null) {
            this.recipients = null;
            return;
        }
        this.recipients = new ArrayList<RecipientDetail>(recipients);
    }

    public SMSConfiguration withRecipients(RecipientDetail ... recipients) {
        if (this.recipients == null) {
            this.setRecipients(new ArrayList<RecipientDetail>(recipients.length));
        }
        for (RecipientDetail ele : recipients) {
            this.recipients.add(ele);
        }
        return this;
    }

    public SMSConfiguration withRecipients(Collection<RecipientDetail> recipients) {
        this.setRecipients(recipients);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSenderId() != null) {
            sb.append("SenderId: ").append(this.getSenderId()).append(",");
        }
        if (this.getAdditionalMessage() != null) {
            sb.append("AdditionalMessage: ").append(this.getAdditionalMessage()).append(",");
        }
        if (this.getRecipients() != null) {
            sb.append("Recipients: ").append(this.getRecipients());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSConfiguration)) {
            return false;
        }
        SMSConfiguration other = (SMSConfiguration)obj;
        if (other.getSenderId() == null ^ this.getSenderId() == null) {
            return false;
        }
        if (other.getSenderId() != null && !other.getSenderId().equals(this.getSenderId())) {
            return false;
        }
        if (other.getAdditionalMessage() == null ^ this.getAdditionalMessage() == null) {
            return false;
        }
        if (other.getAdditionalMessage() != null && !other.getAdditionalMessage().equals(this.getAdditionalMessage())) {
            return false;
        }
        if (other.getRecipients() == null ^ this.getRecipients() == null) {
            return false;
        }
        return other.getRecipients() == null || other.getRecipients().equals(this.getRecipients());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSenderId() == null ? 0 : this.getSenderId().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMessage() == null ? 0 : this.getAdditionalMessage().hashCode());
        hashCode = 31 * hashCode + (this.getRecipients() == null ? 0 : this.getRecipients().hashCode());
        return hashCode;
    }

    public SMSConfiguration clone() {
        try {
            return (SMSConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SMSConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

