/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.DeviceUnderTest;
import com.amazonaws.services.iotdeviceadvisor.model.transform.SuiteDefinitionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SuiteDefinitionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String suiteDefinitionName;
    private List<DeviceUnderTest> devices;
    private Boolean intendedForQualification;
    private String rootGroup;
    private String devicePermissionRoleArn;

    public void setSuiteDefinitionName(String suiteDefinitionName) {
        this.suiteDefinitionName = suiteDefinitionName;
    }

    public String getSuiteDefinitionName() {
        return this.suiteDefinitionName;
    }

    public SuiteDefinitionConfiguration withSuiteDefinitionName(String suiteDefinitionName) {
        this.setSuiteDefinitionName(suiteDefinitionName);
        return this;
    }

    public List<DeviceUnderTest> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<DeviceUnderTest> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<DeviceUnderTest>(devices);
    }

    public SuiteDefinitionConfiguration withDevices(DeviceUnderTest ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<DeviceUnderTest>(devices.length));
        }
        for (DeviceUnderTest ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public SuiteDefinitionConfiguration withDevices(Collection<DeviceUnderTest> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setIntendedForQualification(Boolean intendedForQualification) {
        this.intendedForQualification = intendedForQualification;
    }

    public Boolean getIntendedForQualification() {
        return this.intendedForQualification;
    }

    public SuiteDefinitionConfiguration withIntendedForQualification(Boolean intendedForQualification) {
        this.setIntendedForQualification(intendedForQualification);
        return this;
    }

    public Boolean isIntendedForQualification() {
        return this.intendedForQualification;
    }

    public void setRootGroup(String rootGroup) {
        this.rootGroup = rootGroup;
    }

    public String getRootGroup() {
        return this.rootGroup;
    }

    public SuiteDefinitionConfiguration withRootGroup(String rootGroup) {
        this.setRootGroup(rootGroup);
        return this;
    }

    public void setDevicePermissionRoleArn(String devicePermissionRoleArn) {
        this.devicePermissionRoleArn = devicePermissionRoleArn;
    }

    public String getDevicePermissionRoleArn() {
        return this.devicePermissionRoleArn;
    }

    public SuiteDefinitionConfiguration withDevicePermissionRoleArn(String devicePermissionRoleArn) {
        this.setDevicePermissionRoleArn(devicePermissionRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuiteDefinitionName() != null) {
            sb.append("SuiteDefinitionName: ").append(this.getSuiteDefinitionName()).append(",");
        }
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices()).append(",");
        }
        if (this.getIntendedForQualification() != null) {
            sb.append("IntendedForQualification: ").append(this.getIntendedForQualification()).append(",");
        }
        if (this.getRootGroup() != null) {
            sb.append("RootGroup: ").append(this.getRootGroup()).append(",");
        }
        if (this.getDevicePermissionRoleArn() != null) {
            sb.append("DevicePermissionRoleArn: ").append(this.getDevicePermissionRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionConfiguration)) {
            return false;
        }
        SuiteDefinitionConfiguration other = (SuiteDefinitionConfiguration)obj;
        if (other.getSuiteDefinitionName() == null ^ this.getSuiteDefinitionName() == null) {
            return false;
        }
        if (other.getSuiteDefinitionName() != null && !other.getSuiteDefinitionName().equals(this.getSuiteDefinitionName())) {
            return false;
        }
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getIntendedForQualification() == null ^ this.getIntendedForQualification() == null) {
            return false;
        }
        if (other.getIntendedForQualification() != null && !other.getIntendedForQualification().equals(this.getIntendedForQualification())) {
            return false;
        }
        if (other.getRootGroup() == null ^ this.getRootGroup() == null) {
            return false;
        }
        if (other.getRootGroup() != null && !other.getRootGroup().equals(this.getRootGroup())) {
            return false;
        }
        if (other.getDevicePermissionRoleArn() == null ^ this.getDevicePermissionRoleArn() == null) {
            return false;
        }
        return other.getDevicePermissionRoleArn() == null || other.getDevicePermissionRoleArn().equals(this.getDevicePermissionRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuiteDefinitionName() == null ? 0 : this.getSuiteDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getIntendedForQualification() == null ? 0 : this.getIntendedForQualification().hashCode());
        hashCode = 31 * hashCode + (this.getRootGroup() == null ? 0 : this.getRootGroup().hashCode());
        hashCode = 31 * hashCode + (this.getDevicePermissionRoleArn() == null ? 0 : this.getDevicePermissionRoleArn().hashCode());
        return hashCode;
    }

    public SuiteDefinitionConfiguration clone() {
        try {
            return (SuiteDefinitionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuiteDefinitionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

