/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.TestCase;
import com.amazonaws.services.iotdeviceadvisor.model.transform.TestCaseCategoryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TestCaseCategory
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<TestCase> tests;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TestCaseCategory withName(String name) {
        this.setName(name);
        return this;
    }

    public List<TestCase> getTests() {
        return this.tests;
    }

    public void setTests(Collection<TestCase> tests) {
        if (tests == null) {
            this.tests = null;
            return;
        }
        this.tests = new ArrayList<TestCase>(tests);
    }

    public TestCaseCategory withTests(TestCase ... tests) {
        if (this.tests == null) {
            this.setTests(new ArrayList<TestCase>(tests.length));
        }
        for (TestCase ele : tests) {
            this.tests.add(ele);
        }
        return this;
    }

    public TestCaseCategory withTests(Collection<TestCase> tests) {
        this.setTests(tests);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTests() != null) {
            sb.append("Tests: ").append(this.getTests());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseCategory)) {
            return false;
        }
        TestCaseCategory other = (TestCaseCategory)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTests() == null ^ this.getTests() == null) {
            return false;
        }
        return other.getTests() == null || other.getTests().equals(this.getTests());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTests() == null ? 0 : this.getTests().hashCode());
        return hashCode;
    }

    public TestCaseCategory clone() {
        try {
            return (TestCaseCategory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TestCaseCategoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

