/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.ResourceConfiguration;

@SdkInternalApi
public class ResourceConfigurationMarshaller {
    private static final MarshallingInfo<String> COMPUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeType").build();
    private static final MarshallingInfo<Integer> VOLUMESIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumeSizeInGB").build();
    private static final ResourceConfigurationMarshaller instance = new ResourceConfigurationMarshaller();

    public static ResourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceConfiguration resourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (resourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceConfiguration.getComputeType(), COMPUTETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceConfiguration.getVolumeSizeInGB(), VOLUMESIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

