/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotanalytics.AWSIoTAnalytics;
import com.amazonaws.services.iotanalytics.AWSIoTAnalyticsClientBuilder;
import com.amazonaws.services.iotanalytics.model.AWSIoTAnalyticsException;
import com.amazonaws.services.iotanalytics.model.BatchPutMessageRequest;
import com.amazonaws.services.iotanalytics.model.BatchPutMessageResult;
import com.amazonaws.services.iotanalytics.model.CancelPipelineReprocessingRequest;
import com.amazonaws.services.iotanalytics.model.CancelPipelineReprocessingResult;
import com.amazonaws.services.iotanalytics.model.CreateChannelRequest;
import com.amazonaws.services.iotanalytics.model.CreateChannelResult;
import com.amazonaws.services.iotanalytics.model.CreateDatasetContentRequest;
import com.amazonaws.services.iotanalytics.model.CreateDatasetContentResult;
import com.amazonaws.services.iotanalytics.model.CreateDatasetRequest;
import com.amazonaws.services.iotanalytics.model.CreateDatasetResult;
import com.amazonaws.services.iotanalytics.model.CreateDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.CreateDatastoreResult;
import com.amazonaws.services.iotanalytics.model.CreatePipelineRequest;
import com.amazonaws.services.iotanalytics.model.CreatePipelineResult;
import com.amazonaws.services.iotanalytics.model.DeleteChannelRequest;
import com.amazonaws.services.iotanalytics.model.DeleteChannelResult;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetContentRequest;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetContentResult;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetRequest;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetResult;
import com.amazonaws.services.iotanalytics.model.DeleteDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.DeleteDatastoreResult;
import com.amazonaws.services.iotanalytics.model.DeletePipelineRequest;
import com.amazonaws.services.iotanalytics.model.DeletePipelineResult;
import com.amazonaws.services.iotanalytics.model.DescribeChannelRequest;
import com.amazonaws.services.iotanalytics.model.DescribeChannelResult;
import com.amazonaws.services.iotanalytics.model.DescribeDatasetRequest;
import com.amazonaws.services.iotanalytics.model.DescribeDatasetResult;
import com.amazonaws.services.iotanalytics.model.DescribeDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.DescribeDatastoreResult;
import com.amazonaws.services.iotanalytics.model.DescribeLoggingOptionsRequest;
import com.amazonaws.services.iotanalytics.model.DescribeLoggingOptionsResult;
import com.amazonaws.services.iotanalytics.model.DescribePipelineRequest;
import com.amazonaws.services.iotanalytics.model.DescribePipelineResult;
import com.amazonaws.services.iotanalytics.model.GetDatasetContentRequest;
import com.amazonaws.services.iotanalytics.model.GetDatasetContentResult;
import com.amazonaws.services.iotanalytics.model.InternalFailureException;
import com.amazonaws.services.iotanalytics.model.InvalidRequestException;
import com.amazonaws.services.iotanalytics.model.LimitExceededException;
import com.amazonaws.services.iotanalytics.model.ListChannelsRequest;
import com.amazonaws.services.iotanalytics.model.ListChannelsResult;
import com.amazonaws.services.iotanalytics.model.ListDatasetsRequest;
import com.amazonaws.services.iotanalytics.model.ListDatasetsResult;
import com.amazonaws.services.iotanalytics.model.ListDatastoresRequest;
import com.amazonaws.services.iotanalytics.model.ListDatastoresResult;
import com.amazonaws.services.iotanalytics.model.ListPipelinesRequest;
import com.amazonaws.services.iotanalytics.model.ListPipelinesResult;
import com.amazonaws.services.iotanalytics.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotanalytics.model.ListTagsForResourceResult;
import com.amazonaws.services.iotanalytics.model.PutLoggingOptionsRequest;
import com.amazonaws.services.iotanalytics.model.PutLoggingOptionsResult;
import com.amazonaws.services.iotanalytics.model.ResourceAlreadyExistsException;
import com.amazonaws.services.iotanalytics.model.ResourceNotFoundException;
import com.amazonaws.services.iotanalytics.model.RunPipelineActivityRequest;
import com.amazonaws.services.iotanalytics.model.RunPipelineActivityResult;
import com.amazonaws.services.iotanalytics.model.SampleChannelDataRequest;
import com.amazonaws.services.iotanalytics.model.SampleChannelDataResult;
import com.amazonaws.services.iotanalytics.model.ServiceUnavailableException;
import com.amazonaws.services.iotanalytics.model.StartPipelineReprocessingRequest;
import com.amazonaws.services.iotanalytics.model.StartPipelineReprocessingResult;
import com.amazonaws.services.iotanalytics.model.TagResourceRequest;
import com.amazonaws.services.iotanalytics.model.TagResourceResult;
import com.amazonaws.services.iotanalytics.model.ThrottlingException;
import com.amazonaws.services.iotanalytics.model.UntagResourceRequest;
import com.amazonaws.services.iotanalytics.model.UntagResourceResult;
import com.amazonaws.services.iotanalytics.model.UpdateChannelRequest;
import com.amazonaws.services.iotanalytics.model.UpdateChannelResult;
import com.amazonaws.services.iotanalytics.model.UpdateDatasetRequest;
import com.amazonaws.services.iotanalytics.model.UpdateDatasetResult;
import com.amazonaws.services.iotanalytics.model.UpdateDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.UpdateDatastoreResult;
import com.amazonaws.services.iotanalytics.model.UpdatePipelineRequest;
import com.amazonaws.services.iotanalytics.model.UpdatePipelineResult;
import com.amazonaws.services.iotanalytics.model.transform.BatchPutMessageRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.BatchPutMessageResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CancelPipelineReprocessingRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CancelPipelineReprocessingResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateDatasetContentRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateDatasetContentResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateDatasetRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateDatasetResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreateDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteDatasetContentRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteDatasetContentResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteDatasetRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeleteDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeletePipelineRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeChannelRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeChannelResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeDatasetRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeLoggingOptionsRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribeLoggingOptionsResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribePipelineRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.DescribePipelineResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.GetDatasetContentRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.GetDatasetContentResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListDatasetsRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListDatastoresRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListDatastoresResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListPipelinesRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.PutLoggingOptionsRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.PutLoggingOptionsResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.RunPipelineActivityRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.RunPipelineActivityResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.SampleChannelDataRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.SampleChannelDataResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.StartPipelineReprocessingRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.StartPipelineReprocessingResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdateDatasetRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdateDatasetResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdateDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdateDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoTAnalyticsClient
extends AmazonWebServiceClient
implements AWSIoTAnalytics {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTAnalytics.class);
    private static final String DEFAULT_SIGNING_NAME = "iotanalytics";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).withBaseServiceExceptionClass(AWSIoTAnalyticsException.class));

    public static AWSIoTAnalyticsClientBuilder builder() {
        return AWSIoTAnalyticsClientBuilder.standard();
    }

    AWSIoTAnalyticsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("iotanalytics.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotanalytics/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotanalytics/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchPutMessageResult batchPutMessage(BatchPutMessageRequest request) {
        request = (BatchPutMessageRequest)this.beforeClientExecution(request);
        return this.executeBatchPutMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchPutMessageResult executeBatchPutMessage(BatchPutMessageRequest batchPutMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutMessageRequestProtocolMarshaller(protocolFactory).marshall((BatchPutMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchPutMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchPutMessage");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchPutMessageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchPutMessageResult batchPutMessageResult = (BatchPutMessageResult)response.getAwsResponse();
            return batchPutMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelPipelineReprocessingResult cancelPipelineReprocessing(CancelPipelineReprocessingRequest request) {
        request = (CancelPipelineReprocessingRequest)this.beforeClientExecution(request);
        return this.executeCancelPipelineReprocessing(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelPipelineReprocessingResult executeCancelPipelineReprocessing(CancelPipelineReprocessingRequest cancelPipelineReprocessingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelPipelineReprocessingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelPipelineReprocessingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelPipelineReprocessingRequestProtocolMarshaller(protocolFactory).marshall((CancelPipelineReprocessingRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelPipelineReprocessingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelPipelineReprocessing");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelPipelineReprocessingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelPipelineReprocessingResult cancelPipelineReprocessingResult = (CancelPipelineReprocessingResult)response.getAwsResponse();
            return cancelPipelineReprocessingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        request = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executeCreateDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatasetResult executeCreateDataset(CreateDatasetRequest createDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatasetRequestProtocolMarshaller(protocolFactory).marshall((CreateDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataset");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatasetResult createDatasetResult = (CreateDatasetResult)response.getAwsResponse();
            return createDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDatasetContentResult createDatasetContent(CreateDatasetContentRequest request) {
        request = (CreateDatasetContentRequest)this.beforeClientExecution(request);
        return this.executeCreateDatasetContent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatasetContentResult executeCreateDatasetContent(CreateDatasetContentRequest createDatasetContentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatasetContentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatasetContentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatasetContentRequestProtocolMarshaller(protocolFactory).marshall((CreateDatasetContentRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatasetContentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDatasetContent");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatasetContentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatasetContentResult createDatasetContentResult = (CreateDatasetContentResult)response.getAwsResponse();
            return createDatasetContentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDatastoreResult createDatastore(CreateDatastoreRequest request) {
        request = (CreateDatastoreRequest)this.beforeClientExecution(request);
        return this.executeCreateDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatastoreResult executeCreateDatastore(CreateDatastoreRequest createDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatastoreRequestProtocolMarshaller(protocolFactory).marshall((CreateDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDatastore");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatastoreResult createDatastoreResult = (CreateDatastoreResult)response.getAwsResponse();
            return createDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest request) {
        request = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executeCreatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePipelineResult executeCreatePipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestProtocolMarshaller(protocolFactory).marshall((CreatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePipeline");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        request = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatasetResult executeDeleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataset");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatasetContentResult deleteDatasetContent(DeleteDatasetContentRequest request) {
        request = (DeleteDatasetContentRequest)this.beforeClientExecution(request);
        return this.executeDeleteDatasetContent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatasetContentResult executeDeleteDatasetContent(DeleteDatasetContentRequest deleteDatasetContentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetContentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetContentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetContentRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatasetContentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatasetContentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDatasetContent");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatasetContentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatasetContentResult deleteDatasetContentResult = (DeleteDatasetContentResult)response.getAwsResponse();
            return deleteDatasetContentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatastoreResult deleteDatastore(DeleteDatastoreRequest request) {
        request = (DeleteDatastoreRequest)this.beforeClientExecution(request);
        return this.executeDeleteDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatastoreResult executeDeleteDatastore(DeleteDatastoreRequest deleteDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatastoreRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDatastore");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatastoreResult deleteDatastoreResult = (DeleteDatastoreResult)response.getAwsResponse();
            return deleteDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest request) {
        request = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executeDeletePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePipelineResult executeDeletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestProtocolMarshaller(protocolFactory).marshall((DeletePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePipeline");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePipelineResult deletePipelineResult = (DeletePipelineResult)response.getAwsResponse();
            return deletePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        request = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executeDescribeChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeChannelResult executeDescribeChannel(DescribeChannelRequest describeChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeChannelRequestProtocolMarshaller(protocolFactory).marshall((DescribeChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeChannelResult describeChannelResult = (DescribeChannelResult)response.getAwsResponse();
            return describeChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        request = (DescribeDatasetRequest)this.beforeClientExecution(request);
        return this.executeDescribeDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDatasetResult executeDescribeDataset(DescribeDatasetRequest describeDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestProtocolMarshaller(protocolFactory).marshall((DescribeDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDataset");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDatasetResult describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            return describeDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDatastoreResult describeDatastore(DescribeDatastoreRequest request) {
        request = (DescribeDatastoreRequest)this.beforeClientExecution(request);
        return this.executeDescribeDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDatastoreResult executeDescribeDatastore(DescribeDatastoreRequest describeDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatastoreRequestProtocolMarshaller(protocolFactory).marshall((DescribeDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDatastore");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDatastoreResult describeDatastoreResult = (DescribeDatastoreResult)response.getAwsResponse();
            return describeDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLoggingOptionsResult describeLoggingOptions(DescribeLoggingOptionsRequest request) {
        request = (DescribeLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeLoggingOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLoggingOptionsResult executeDescribeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLoggingOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLoggingOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLoggingOptionsRequestProtocolMarshaller(protocolFactory).marshall((DescribeLoggingOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLoggingOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLoggingOptions");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLoggingOptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLoggingOptionsResult describeLoggingOptionsResult = (DescribeLoggingOptionsResult)response.getAwsResponse();
            return describeLoggingOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePipelineResult describePipeline(DescribePipelineRequest request) {
        request = (DescribePipelineRequest)this.beforeClientExecution(request);
        return this.executeDescribePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePipelineResult executeDescribePipeline(DescribePipelineRequest describePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePipelineRequestProtocolMarshaller(protocolFactory).marshall((DescribePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribePipeline");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePipelineResult describePipelineResult = (DescribePipelineResult)response.getAwsResponse();
            return describePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDatasetContentResult getDatasetContent(GetDatasetContentRequest request) {
        request = (GetDatasetContentRequest)this.beforeClientExecution(request);
        return this.executeGetDatasetContent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDatasetContentResult executeGetDatasetContent(GetDatasetContentRequest getDatasetContentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDatasetContentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDatasetContentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDatasetContentRequestProtocolMarshaller(protocolFactory).marshall((GetDatasetContentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDatasetContentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDatasetContent");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDatasetContentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDatasetContentResult getDatasetContentResult = (GetDatasetContentResult)response.getAwsResponse();
            return getDatasetContentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannels");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        request = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executeListDatasets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatasetsResult executeListDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestProtocolMarshaller(protocolFactory).marshall((ListDatasetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatasetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatasets");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatasetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatastoresResult listDatastores(ListDatastoresRequest request) {
        request = (ListDatastoresRequest)this.beforeClientExecution(request);
        return this.executeListDatastores(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatastoresResult executeListDatastores(ListDatastoresRequest listDatastoresRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatastoresRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatastoresRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatastoresRequestProtocolMarshaller(protocolFactory).marshall((ListDatastoresRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatastoresRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatastores");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatastoresResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatastoresResult listDatastoresResult = (ListDatastoresResult)response.getAwsResponse();
            return listDatastoresResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest request) {
        request = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executeListPipelines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPipelinesResult executeListPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestProtocolMarshaller(protocolFactory).marshall((ListPipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPipelines");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLoggingOptionsResult putLoggingOptions(PutLoggingOptionsRequest request) {
        request = (PutLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executePutLoggingOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLoggingOptionsResult executePutLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLoggingOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLoggingOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLoggingOptionsRequestProtocolMarshaller(protocolFactory).marshall((PutLoggingOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putLoggingOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutLoggingOptions");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutLoggingOptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLoggingOptionsResult putLoggingOptionsResult = (PutLoggingOptionsResult)response.getAwsResponse();
            return putLoggingOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RunPipelineActivityResult runPipelineActivity(RunPipelineActivityRequest request) {
        request = (RunPipelineActivityRequest)this.beforeClientExecution(request);
        return this.executeRunPipelineActivity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RunPipelineActivityResult executeRunPipelineActivity(RunPipelineActivityRequest runPipelineActivityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runPipelineActivityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunPipelineActivityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunPipelineActivityRequestProtocolMarshaller(protocolFactory).marshall((RunPipelineActivityRequest)super.beforeMarshalling((AmazonWebServiceRequest)runPipelineActivityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RunPipelineActivity");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RunPipelineActivityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RunPipelineActivityResult runPipelineActivityResult = (RunPipelineActivityResult)response.getAwsResponse();
            return runPipelineActivityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SampleChannelDataResult sampleChannelData(SampleChannelDataRequest request) {
        request = (SampleChannelDataRequest)this.beforeClientExecution(request);
        return this.executeSampleChannelData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SampleChannelDataResult executeSampleChannelData(SampleChannelDataRequest sampleChannelDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sampleChannelDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SampleChannelDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SampleChannelDataRequestProtocolMarshaller(protocolFactory).marshall((SampleChannelDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)sampleChannelDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SampleChannelData");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SampleChannelDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SampleChannelDataResult sampleChannelDataResult = (SampleChannelDataResult)response.getAwsResponse();
            return sampleChannelDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartPipelineReprocessingResult startPipelineReprocessing(StartPipelineReprocessingRequest request) {
        request = (StartPipelineReprocessingRequest)this.beforeClientExecution(request);
        return this.executeStartPipelineReprocessing(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartPipelineReprocessingResult executeStartPipelineReprocessing(StartPipelineReprocessingRequest startPipelineReprocessingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startPipelineReprocessingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartPipelineReprocessingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartPipelineReprocessingRequestProtocolMarshaller(protocolFactory).marshall((StartPipelineReprocessingRequest)super.beforeMarshalling((AmazonWebServiceRequest)startPipelineReprocessingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartPipelineReprocessing");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartPipelineReprocessingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartPipelineReprocessingResult startPipelineReprocessingResult = (StartPipelineReprocessingResult)response.getAwsResponse();
            return startPipelineReprocessingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDatasetResult updateDataset(UpdateDatasetRequest request) {
        request = (UpdateDatasetRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDatasetResult executeUpdateDataset(UpdateDatasetRequest updateDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDatasetRequestProtocolMarshaller(protocolFactory).marshall((UpdateDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataset");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDatasetResult updateDatasetResult = (UpdateDatasetResult)response.getAwsResponse();
            return updateDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDatastoreResult updateDatastore(UpdateDatastoreRequest request) {
        request = (UpdateDatastoreRequest)this.beforeClientExecution(request);
        return this.executeUpdateDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDatastoreResult executeUpdateDatastore(UpdateDatastoreRequest updateDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDatastoreRequestProtocolMarshaller(protocolFactory).marshall((UpdateDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDatastore");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDatastoreResult updateDatastoreResult = (UpdateDatastoreResult)response.getAwsResponse();
            return updateDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest request) {
        request = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executeUpdatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePipelineResult executeUpdatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestProtocolMarshaller(protocolFactory).marshall((UpdatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTAnalytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePipeline");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineResult updatePipelineResult = (UpdatePipelineResult)response.getAwsResponse();
            return updatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

