/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.ThingDocument;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ThingDocumentMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").build();
    private static final MarshallingInfo<String> THINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingId").build();
    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").build();
    private static final MarshallingInfo<List> THINGGROUPNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupNames").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<String> SHADOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shadow").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIVITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectivity").build();
    private static final ThingDocumentMarshaller instance = new ThingDocumentMarshaller();

    public static ThingDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(ThingDocument thingDocument, ProtocolMarshaller protocolMarshaller) {
        if (thingDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)thingDocument.getThingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.getThingId(), THINGID_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.getThingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall(thingDocument.getThingGroupNames(), THINGGROUPNAMES_BINDING);
            protocolMarshaller.marshall(thingDocument.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.getShadow(), SHADOW_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.getConnectivity(), CONNECTIVITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

