/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.AuthorizerStatus;
import com.amazonaws.services.iot.model.transform.AuthorizerDescriptionMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AuthorizerDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String authorizerName;
    private String authorizerArn;
    private String authorizerFunctionArn;
    private String tokenKeyName;
    private Map<String, String> tokenSigningPublicKeys;
    private String status;
    private Date creationDate;
    private Date lastModifiedDate;
    private Boolean signingDisabled;

    public void setAuthorizerName(String authorizerName) {
        this.authorizerName = authorizerName;
    }

    public String getAuthorizerName() {
        return this.authorizerName;
    }

    public AuthorizerDescription withAuthorizerName(String authorizerName) {
        this.setAuthorizerName(authorizerName);
        return this;
    }

    public void setAuthorizerArn(String authorizerArn) {
        this.authorizerArn = authorizerArn;
    }

    public String getAuthorizerArn() {
        return this.authorizerArn;
    }

    public AuthorizerDescription withAuthorizerArn(String authorizerArn) {
        this.setAuthorizerArn(authorizerArn);
        return this;
    }

    public void setAuthorizerFunctionArn(String authorizerFunctionArn) {
        this.authorizerFunctionArn = authorizerFunctionArn;
    }

    public String getAuthorizerFunctionArn() {
        return this.authorizerFunctionArn;
    }

    public AuthorizerDescription withAuthorizerFunctionArn(String authorizerFunctionArn) {
        this.setAuthorizerFunctionArn(authorizerFunctionArn);
        return this;
    }

    public void setTokenKeyName(String tokenKeyName) {
        this.tokenKeyName = tokenKeyName;
    }

    public String getTokenKeyName() {
        return this.tokenKeyName;
    }

    public AuthorizerDescription withTokenKeyName(String tokenKeyName) {
        this.setTokenKeyName(tokenKeyName);
        return this;
    }

    public Map<String, String> getTokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys;
    }

    public void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
        this.tokenSigningPublicKeys = tokenSigningPublicKeys;
    }

    public AuthorizerDescription withTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
        this.setTokenSigningPublicKeys(tokenSigningPublicKeys);
        return this;
    }

    public AuthorizerDescription addTokenSigningPublicKeysEntry(String key, String value) {
        if (null == this.tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = new HashMap<String, String>();
        }
        if (this.tokenSigningPublicKeys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tokenSigningPublicKeys.put(key, value);
        return this;
    }

    public AuthorizerDescription clearTokenSigningPublicKeysEntries() {
        this.tokenSigningPublicKeys = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AuthorizerDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AuthorizerDescription withStatus(AuthorizerStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public AuthorizerDescription withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public AuthorizerDescription withLastModifiedDate(Date lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setSigningDisabled(Boolean signingDisabled) {
        this.signingDisabled = signingDisabled;
    }

    public Boolean getSigningDisabled() {
        return this.signingDisabled;
    }

    public AuthorizerDescription withSigningDisabled(Boolean signingDisabled) {
        this.setSigningDisabled(signingDisabled);
        return this;
    }

    public Boolean isSigningDisabled() {
        return this.signingDisabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthorizerName() != null) {
            sb.append("AuthorizerName: ").append(this.getAuthorizerName()).append(",");
        }
        if (this.getAuthorizerArn() != null) {
            sb.append("AuthorizerArn: ").append(this.getAuthorizerArn()).append(",");
        }
        if (this.getAuthorizerFunctionArn() != null) {
            sb.append("AuthorizerFunctionArn: ").append(this.getAuthorizerFunctionArn()).append(",");
        }
        if (this.getTokenKeyName() != null) {
            sb.append("TokenKeyName: ").append(this.getTokenKeyName()).append(",");
        }
        if (this.getTokenSigningPublicKeys() != null) {
            sb.append("TokenSigningPublicKeys: ").append(this.getTokenSigningPublicKeys()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getSigningDisabled() != null) {
            sb.append("SigningDisabled: ").append(this.getSigningDisabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizerDescription)) {
            return false;
        }
        AuthorizerDescription other = (AuthorizerDescription)obj;
        if (other.getAuthorizerName() == null ^ this.getAuthorizerName() == null) {
            return false;
        }
        if (other.getAuthorizerName() != null && !other.getAuthorizerName().equals(this.getAuthorizerName())) {
            return false;
        }
        if (other.getAuthorizerArn() == null ^ this.getAuthorizerArn() == null) {
            return false;
        }
        if (other.getAuthorizerArn() != null && !other.getAuthorizerArn().equals(this.getAuthorizerArn())) {
            return false;
        }
        if (other.getAuthorizerFunctionArn() == null ^ this.getAuthorizerFunctionArn() == null) {
            return false;
        }
        if (other.getAuthorizerFunctionArn() != null && !other.getAuthorizerFunctionArn().equals(this.getAuthorizerFunctionArn())) {
            return false;
        }
        if (other.getTokenKeyName() == null ^ this.getTokenKeyName() == null) {
            return false;
        }
        if (other.getTokenKeyName() != null && !other.getTokenKeyName().equals(this.getTokenKeyName())) {
            return false;
        }
        if (other.getTokenSigningPublicKeys() == null ^ this.getTokenSigningPublicKeys() == null) {
            return false;
        }
        if (other.getTokenSigningPublicKeys() != null && !other.getTokenSigningPublicKeys().equals(this.getTokenSigningPublicKeys())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getSigningDisabled() == null ^ this.getSigningDisabled() == null) {
            return false;
        }
        return other.getSigningDisabled() == null || other.getSigningDisabled().equals(this.getSigningDisabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthorizerName() == null ? 0 : this.getAuthorizerName().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizerArn() == null ? 0 : this.getAuthorizerArn().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizerFunctionArn() == null ? 0 : this.getAuthorizerFunctionArn().hashCode());
        hashCode = 31 * hashCode + (this.getTokenKeyName() == null ? 0 : this.getTokenKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getTokenSigningPublicKeys() == null ? 0 : this.getTokenSigningPublicKeys().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getSigningDisabled() == null ? 0 : this.getSigningDisabled().hashCode());
        return hashCode;
    }

    public AuthorizerDescription clone() {
        try {
            return (AuthorizerDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthorizerDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

