/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.TransferData;

public class TransferDataJsonMarshaller {
    private static TransferDataJsonMarshaller instance;

    public void marshall(TransferData transferData, StructuredJsonGenerator jsonGenerator) {
        if (transferData == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (transferData.getTransferMessage() != null) {
                jsonGenerator.writeFieldName("transferMessage").writeValue(transferData.getTransferMessage());
            }
            if (transferData.getRejectReason() != null) {
                jsonGenerator.writeFieldName("rejectReason").writeValue(transferData.getRejectReason());
            }
            if (transferData.getTransferDate() != null) {
                jsonGenerator.writeFieldName("transferDate").writeValue(transferData.getTransferDate());
            }
            if (transferData.getAcceptDate() != null) {
                jsonGenerator.writeFieldName("acceptDate").writeValue(transferData.getAcceptDate());
            }
            if (transferData.getRejectDate() != null) {
                jsonGenerator.writeFieldName("rejectDate").writeValue(transferData.getRejectDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TransferDataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TransferDataJsonMarshaller();
        }
        return instance;
    }
}

