/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.AttachThingPrincipalRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AttachThingPrincipalRequestMarshaller
implements Marshaller<Request<AttachThingPrincipalRequest>, AttachThingPrincipalRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public AttachThingPrincipalRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AttachThingPrincipalRequest> marshall(AttachThingPrincipalRequest attachThingPrincipalRequest) {
        if (attachThingPrincipalRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachThingPrincipalRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PUT);
        if (attachThingPrincipalRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)attachThingPrincipalRequest.getPrincipal()));
        }
        String uriResourcePath = "/things/{thingName}/principals";
        uriResourcePath = uriResourcePath.replace("{thingName}", attachThingPrincipalRequest.getThingName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)attachThingPrincipalRequest.getThingName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

