/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListCertificatesByCARequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListCertificatesByCARequestMarshaller
implements Marshaller<Request<ListCertificatesByCARequest>, ListCertificatesByCARequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListCertificatesByCARequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListCertificatesByCARequest> marshall(ListCertificatesByCARequest listCertificatesByCARequest) {
        if (listCertificatesByCARequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCertificatesByCARequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/certificates-by-ca/{caCertificateId}";
        uriResourcePath = uriResourcePath.replace("{caCertificateId}", listCertificatesByCARequest.getCaCertificateId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listCertificatesByCARequest.getCaCertificateId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (listCertificatesByCARequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listCertificatesByCARequest.getPageSize()));
        }
        if (listCertificatesByCARequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listCertificatesByCARequest.getMarker()));
        }
        if (listCertificatesByCARequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listCertificatesByCARequest.getAscendingOrder()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

