/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListCACertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListCACertificatesRequestMarshaller
implements Marshaller<Request<ListCACertificatesRequest>, ListCACertificatesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListCACertificatesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListCACertificatesRequest> marshall(ListCACertificatesRequest listCACertificatesRequest) {
        if (listCACertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCACertificatesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/cacertificates";
        request.setResourcePath(uriResourcePath);
        if (listCACertificatesRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listCACertificatesRequest.getPageSize()));
        }
        if (listCACertificatesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listCACertificatesRequest.getMarker()));
        }
        if (listCACertificatesRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listCACertificatesRequest.getAscendingOrder()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

