/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.transform.ThingAttributeMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ThingAttribute
implements Serializable,
Cloneable,
StructuredPojo {
    private String thingName;
    private String thingTypeName;
    private String thingArn;
    private Map<String, String> attributes;
    private Long version;

    public void setThingName(String thingName) {
        this.thingName = thingName;
    }

    public String getThingName() {
        return this.thingName;
    }

    public ThingAttribute withThingName(String thingName) {
        this.setThingName(thingName);
        return this;
    }

    public void setThingTypeName(String thingTypeName) {
        this.thingTypeName = thingTypeName;
    }

    public String getThingTypeName() {
        return this.thingTypeName;
    }

    public ThingAttribute withThingTypeName(String thingTypeName) {
        this.setThingTypeName(thingTypeName);
        return this;
    }

    public void setThingArn(String thingArn) {
        this.thingArn = thingArn;
    }

    public String getThingArn() {
        return this.thingArn;
    }

    public ThingAttribute withThingArn(String thingArn) {
        this.setThingArn(thingArn);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThingAttribute withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public ThingAttribute addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public ThingAttribute clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public ThingAttribute withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getThingName() != null) {
            sb.append("ThingName: ").append(this.getThingName()).append(",");
        }
        if (this.getThingTypeName() != null) {
            sb.append("ThingTypeName: ").append(this.getThingTypeName()).append(",");
        }
        if (this.getThingArn() != null) {
            sb.append("ThingArn: ").append(this.getThingArn()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingAttribute)) {
            return false;
        }
        ThingAttribute other = (ThingAttribute)obj;
        if (other.getThingName() == null ^ this.getThingName() == null) {
            return false;
        }
        if (other.getThingName() != null && !other.getThingName().equals(this.getThingName())) {
            return false;
        }
        if (other.getThingTypeName() == null ^ this.getThingTypeName() == null) {
            return false;
        }
        if (other.getThingTypeName() != null && !other.getThingTypeName().equals(this.getThingTypeName())) {
            return false;
        }
        if (other.getThingArn() == null ^ this.getThingArn() == null) {
            return false;
        }
        if (other.getThingArn() != null && !other.getThingArn().equals(this.getThingArn())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getThingName() == null ? 0 : this.getThingName().hashCode());
        hashCode = 31 * hashCode + (this.getThingTypeName() == null ? 0 : this.getThingTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getThingArn() == null ? 0 : this.getThingArn().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public ThingAttribute clone() {
        try {
            return (ThingAttribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

