/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iot.AWSIotAsync;
import com.amazonaws.services.iot.AWSIotClient;
import com.amazonaws.services.iot.model.AcceptCertificateTransferRequest;
import com.amazonaws.services.iot.model.AcceptCertificateTransferResult;
import com.amazonaws.services.iot.model.AttachPrincipalPolicyRequest;
import com.amazonaws.services.iot.model.AttachPrincipalPolicyResult;
import com.amazonaws.services.iot.model.AttachThingPrincipalRequest;
import com.amazonaws.services.iot.model.AttachThingPrincipalResult;
import com.amazonaws.services.iot.model.CancelCertificateTransferRequest;
import com.amazonaws.services.iot.model.CancelCertificateTransferResult;
import com.amazonaws.services.iot.model.CreateCertificateFromCsrRequest;
import com.amazonaws.services.iot.model.CreateCertificateFromCsrResult;
import com.amazonaws.services.iot.model.CreateKeysAndCertificateRequest;
import com.amazonaws.services.iot.model.CreateKeysAndCertificateResult;
import com.amazonaws.services.iot.model.CreatePolicyRequest;
import com.amazonaws.services.iot.model.CreatePolicyResult;
import com.amazonaws.services.iot.model.CreatePolicyVersionRequest;
import com.amazonaws.services.iot.model.CreatePolicyVersionResult;
import com.amazonaws.services.iot.model.CreateThingRequest;
import com.amazonaws.services.iot.model.CreateThingResult;
import com.amazonaws.services.iot.model.CreateTopicRuleRequest;
import com.amazonaws.services.iot.model.CreateTopicRuleResult;
import com.amazonaws.services.iot.model.DeleteCACertificateRequest;
import com.amazonaws.services.iot.model.DeleteCACertificateResult;
import com.amazonaws.services.iot.model.DeleteCertificateRequest;
import com.amazonaws.services.iot.model.DeleteCertificateResult;
import com.amazonaws.services.iot.model.DeletePolicyRequest;
import com.amazonaws.services.iot.model.DeletePolicyResult;
import com.amazonaws.services.iot.model.DeletePolicyVersionRequest;
import com.amazonaws.services.iot.model.DeletePolicyVersionResult;
import com.amazonaws.services.iot.model.DeleteRegistrationCodeRequest;
import com.amazonaws.services.iot.model.DeleteRegistrationCodeResult;
import com.amazonaws.services.iot.model.DeleteThingRequest;
import com.amazonaws.services.iot.model.DeleteThingResult;
import com.amazonaws.services.iot.model.DeleteTopicRuleRequest;
import com.amazonaws.services.iot.model.DeleteTopicRuleResult;
import com.amazonaws.services.iot.model.DescribeCACertificateRequest;
import com.amazonaws.services.iot.model.DescribeCACertificateResult;
import com.amazonaws.services.iot.model.DescribeCertificateRequest;
import com.amazonaws.services.iot.model.DescribeCertificateResult;
import com.amazonaws.services.iot.model.DescribeEndpointRequest;
import com.amazonaws.services.iot.model.DescribeEndpointResult;
import com.amazonaws.services.iot.model.DescribeThingRequest;
import com.amazonaws.services.iot.model.DescribeThingResult;
import com.amazonaws.services.iot.model.DetachPrincipalPolicyRequest;
import com.amazonaws.services.iot.model.DetachPrincipalPolicyResult;
import com.amazonaws.services.iot.model.DetachThingPrincipalRequest;
import com.amazonaws.services.iot.model.DetachThingPrincipalResult;
import com.amazonaws.services.iot.model.DisableTopicRuleRequest;
import com.amazonaws.services.iot.model.DisableTopicRuleResult;
import com.amazonaws.services.iot.model.EnableTopicRuleRequest;
import com.amazonaws.services.iot.model.EnableTopicRuleResult;
import com.amazonaws.services.iot.model.GetLoggingOptionsRequest;
import com.amazonaws.services.iot.model.GetLoggingOptionsResult;
import com.amazonaws.services.iot.model.GetPolicyRequest;
import com.amazonaws.services.iot.model.GetPolicyResult;
import com.amazonaws.services.iot.model.GetPolicyVersionRequest;
import com.amazonaws.services.iot.model.GetPolicyVersionResult;
import com.amazonaws.services.iot.model.GetRegistrationCodeRequest;
import com.amazonaws.services.iot.model.GetRegistrationCodeResult;
import com.amazonaws.services.iot.model.GetTopicRuleRequest;
import com.amazonaws.services.iot.model.GetTopicRuleResult;
import com.amazonaws.services.iot.model.ListCACertificatesRequest;
import com.amazonaws.services.iot.model.ListCACertificatesResult;
import com.amazonaws.services.iot.model.ListCertificatesByCARequest;
import com.amazonaws.services.iot.model.ListCertificatesByCAResult;
import com.amazonaws.services.iot.model.ListCertificatesRequest;
import com.amazonaws.services.iot.model.ListCertificatesResult;
import com.amazonaws.services.iot.model.ListPoliciesRequest;
import com.amazonaws.services.iot.model.ListPoliciesResult;
import com.amazonaws.services.iot.model.ListPolicyPrincipalsRequest;
import com.amazonaws.services.iot.model.ListPolicyPrincipalsResult;
import com.amazonaws.services.iot.model.ListPolicyVersionsRequest;
import com.amazonaws.services.iot.model.ListPolicyVersionsResult;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesRequest;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesResult;
import com.amazonaws.services.iot.model.ListPrincipalThingsRequest;
import com.amazonaws.services.iot.model.ListPrincipalThingsResult;
import com.amazonaws.services.iot.model.ListThingPrincipalsRequest;
import com.amazonaws.services.iot.model.ListThingPrincipalsResult;
import com.amazonaws.services.iot.model.ListThingsRequest;
import com.amazonaws.services.iot.model.ListThingsResult;
import com.amazonaws.services.iot.model.ListTopicRulesRequest;
import com.amazonaws.services.iot.model.ListTopicRulesResult;
import com.amazonaws.services.iot.model.RegisterCACertificateRequest;
import com.amazonaws.services.iot.model.RegisterCACertificateResult;
import com.amazonaws.services.iot.model.RegisterCertificateRequest;
import com.amazonaws.services.iot.model.RegisterCertificateResult;
import com.amazonaws.services.iot.model.RejectCertificateTransferRequest;
import com.amazonaws.services.iot.model.RejectCertificateTransferResult;
import com.amazonaws.services.iot.model.ReplaceTopicRuleRequest;
import com.amazonaws.services.iot.model.ReplaceTopicRuleResult;
import com.amazonaws.services.iot.model.SetDefaultPolicyVersionRequest;
import com.amazonaws.services.iot.model.SetDefaultPolicyVersionResult;
import com.amazonaws.services.iot.model.SetLoggingOptionsRequest;
import com.amazonaws.services.iot.model.SetLoggingOptionsResult;
import com.amazonaws.services.iot.model.TransferCertificateRequest;
import com.amazonaws.services.iot.model.TransferCertificateResult;
import com.amazonaws.services.iot.model.UpdateCACertificateRequest;
import com.amazonaws.services.iot.model.UpdateCACertificateResult;
import com.amazonaws.services.iot.model.UpdateCertificateRequest;
import com.amazonaws.services.iot.model.UpdateCertificateResult;
import com.amazonaws.services.iot.model.UpdateThingRequest;
import com.amazonaws.services.iot.model.UpdateThingResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIotAsyncClient
extends AWSIotClient
implements AWSIotAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSIotAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSIotAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSIotAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSIotAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSIotAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSIotAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSIotAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptCertificateTransferResult> acceptCertificateTransferAsync(AcceptCertificateTransferRequest request) {
        return this.acceptCertificateTransferAsync(request, null);
    }

    @Override
    public Future<AcceptCertificateTransferResult> acceptCertificateTransferAsync(final AcceptCertificateTransferRequest request, final AsyncHandler<AcceptCertificateTransferRequest, AcceptCertificateTransferResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcceptCertificateTransferResult>(){

            @Override
            public AcceptCertificateTransferResult call() throws Exception {
                AcceptCertificateTransferResult result;
                try {
                    result = AWSIotAsyncClient.this.acceptCertificateTransfer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachPrincipalPolicyResult> attachPrincipalPolicyAsync(AttachPrincipalPolicyRequest request) {
        return this.attachPrincipalPolicyAsync(request, null);
    }

    @Override
    public Future<AttachPrincipalPolicyResult> attachPrincipalPolicyAsync(final AttachPrincipalPolicyRequest request, final AsyncHandler<AttachPrincipalPolicyRequest, AttachPrincipalPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachPrincipalPolicyResult>(){

            @Override
            public AttachPrincipalPolicyResult call() throws Exception {
                AttachPrincipalPolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.attachPrincipalPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachThingPrincipalResult> attachThingPrincipalAsync(AttachThingPrincipalRequest request) {
        return this.attachThingPrincipalAsync(request, null);
    }

    @Override
    public Future<AttachThingPrincipalResult> attachThingPrincipalAsync(final AttachThingPrincipalRequest request, final AsyncHandler<AttachThingPrincipalRequest, AttachThingPrincipalResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachThingPrincipalResult>(){

            @Override
            public AttachThingPrincipalResult call() throws Exception {
                AttachThingPrincipalResult result;
                try {
                    result = AWSIotAsyncClient.this.attachThingPrincipal(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelCertificateTransferResult> cancelCertificateTransferAsync(CancelCertificateTransferRequest request) {
        return this.cancelCertificateTransferAsync(request, null);
    }

    @Override
    public Future<CancelCertificateTransferResult> cancelCertificateTransferAsync(final CancelCertificateTransferRequest request, final AsyncHandler<CancelCertificateTransferRequest, CancelCertificateTransferResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelCertificateTransferResult>(){

            @Override
            public CancelCertificateTransferResult call() throws Exception {
                CancelCertificateTransferResult result;
                try {
                    result = AWSIotAsyncClient.this.cancelCertificateTransfer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCertificateFromCsrResult> createCertificateFromCsrAsync(CreateCertificateFromCsrRequest request) {
        return this.createCertificateFromCsrAsync(request, null);
    }

    @Override
    public Future<CreateCertificateFromCsrResult> createCertificateFromCsrAsync(final CreateCertificateFromCsrRequest request, final AsyncHandler<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCertificateFromCsrResult>(){

            @Override
            public CreateCertificateFromCsrResult call() throws Exception {
                CreateCertificateFromCsrResult result;
                try {
                    result = AWSIotAsyncClient.this.createCertificateFromCsr(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateKeysAndCertificateResult> createKeysAndCertificateAsync(CreateKeysAndCertificateRequest request) {
        return this.createKeysAndCertificateAsync(request, null);
    }

    @Override
    public Future<CreateKeysAndCertificateResult> createKeysAndCertificateAsync(final CreateKeysAndCertificateRequest request, final AsyncHandler<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateKeysAndCertificateResult>(){

            @Override
            public CreateKeysAndCertificateResult call() throws Exception {
                CreateKeysAndCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.createKeysAndCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePolicyResult> createPolicyAsync(CreatePolicyRequest request) {
        return this.createPolicyAsync(request, null);
    }

    @Override
    public Future<CreatePolicyResult> createPolicyAsync(final CreatePolicyRequest request, final AsyncHandler<CreatePolicyRequest, CreatePolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePolicyResult>(){

            @Override
            public CreatePolicyResult call() throws Exception {
                CreatePolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.createPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePolicyVersionResult> createPolicyVersionAsync(CreatePolicyVersionRequest request) {
        return this.createPolicyVersionAsync(request, null);
    }

    @Override
    public Future<CreatePolicyVersionResult> createPolicyVersionAsync(final CreatePolicyVersionRequest request, final AsyncHandler<CreatePolicyVersionRequest, CreatePolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePolicyVersionResult>(){

            @Override
            public CreatePolicyVersionResult call() throws Exception {
                CreatePolicyVersionResult result;
                try {
                    result = AWSIotAsyncClient.this.createPolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateThingResult> createThingAsync(CreateThingRequest request) {
        return this.createThingAsync(request, null);
    }

    @Override
    public Future<CreateThingResult> createThingAsync(final CreateThingRequest request, final AsyncHandler<CreateThingRequest, CreateThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateThingResult>(){

            @Override
            public CreateThingResult call() throws Exception {
                CreateThingResult result;
                try {
                    result = AWSIotAsyncClient.this.createThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTopicRuleResult> createTopicRuleAsync(CreateTopicRuleRequest request) {
        return this.createTopicRuleAsync(request, null);
    }

    @Override
    public Future<CreateTopicRuleResult> createTopicRuleAsync(final CreateTopicRuleRequest request, final AsyncHandler<CreateTopicRuleRequest, CreateTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTopicRuleResult>(){

            @Override
            public CreateTopicRuleResult call() throws Exception {
                CreateTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.createTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCACertificateResult> deleteCACertificateAsync(DeleteCACertificateRequest request) {
        return this.deleteCACertificateAsync(request, null);
    }

    @Override
    public Future<DeleteCACertificateResult> deleteCACertificateAsync(final DeleteCACertificateRequest request, final AsyncHandler<DeleteCACertificateRequest, DeleteCACertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCACertificateResult>(){

            @Override
            public DeleteCACertificateResult call() throws Exception {
                DeleteCACertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.deleteCACertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCertificateResult> deleteCertificateAsync(DeleteCertificateRequest request) {
        return this.deleteCertificateAsync(request, null);
    }

    @Override
    public Future<DeleteCertificateResult> deleteCertificateAsync(final DeleteCertificateRequest request, final AsyncHandler<DeleteCertificateRequest, DeleteCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCertificateResult>(){

            @Override
            public DeleteCertificateResult call() throws Exception {
                DeleteCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.deleteCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(final DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, DeletePolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePolicyResult>(){

            @Override
            public DeletePolicyResult call() throws Exception {
                DeletePolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.deletePolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePolicyVersionResult> deletePolicyVersionAsync(DeletePolicyVersionRequest request) {
        return this.deletePolicyVersionAsync(request, null);
    }

    @Override
    public Future<DeletePolicyVersionResult> deletePolicyVersionAsync(final DeletePolicyVersionRequest request, final AsyncHandler<DeletePolicyVersionRequest, DeletePolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePolicyVersionResult>(){

            @Override
            public DeletePolicyVersionResult call() throws Exception {
                DeletePolicyVersionResult result;
                try {
                    result = AWSIotAsyncClient.this.deletePolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRegistrationCodeResult> deleteRegistrationCodeAsync(DeleteRegistrationCodeRequest request) {
        return this.deleteRegistrationCodeAsync(request, null);
    }

    @Override
    public Future<DeleteRegistrationCodeResult> deleteRegistrationCodeAsync(final DeleteRegistrationCodeRequest request, final AsyncHandler<DeleteRegistrationCodeRequest, DeleteRegistrationCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRegistrationCodeResult>(){

            @Override
            public DeleteRegistrationCodeResult call() throws Exception {
                DeleteRegistrationCodeResult result;
                try {
                    result = AWSIotAsyncClient.this.deleteRegistrationCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteThingResult> deleteThingAsync(DeleteThingRequest request) {
        return this.deleteThingAsync(request, null);
    }

    @Override
    public Future<DeleteThingResult> deleteThingAsync(final DeleteThingRequest request, final AsyncHandler<DeleteThingRequest, DeleteThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteThingResult>(){

            @Override
            public DeleteThingResult call() throws Exception {
                DeleteThingResult result;
                try {
                    result = AWSIotAsyncClient.this.deleteThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTopicRuleResult> deleteTopicRuleAsync(DeleteTopicRuleRequest request) {
        return this.deleteTopicRuleAsync(request, null);
    }

    @Override
    public Future<DeleteTopicRuleResult> deleteTopicRuleAsync(final DeleteTopicRuleRequest request, final AsyncHandler<DeleteTopicRuleRequest, DeleteTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTopicRuleResult>(){

            @Override
            public DeleteTopicRuleResult call() throws Exception {
                DeleteTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.deleteTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCACertificateResult> describeCACertificateAsync(DescribeCACertificateRequest request) {
        return this.describeCACertificateAsync(request, null);
    }

    @Override
    public Future<DescribeCACertificateResult> describeCACertificateAsync(final DescribeCACertificateRequest request, final AsyncHandler<DescribeCACertificateRequest, DescribeCACertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCACertificateResult>(){

            @Override
            public DescribeCACertificateResult call() throws Exception {
                DescribeCACertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.describeCACertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(DescribeCertificateRequest request) {
        return this.describeCertificateAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(final DescribeCertificateRequest request, final AsyncHandler<DescribeCertificateRequest, DescribeCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCertificateResult>(){

            @Override
            public DescribeCertificateResult call() throws Exception {
                DescribeCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.describeCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointResult> describeEndpointAsync(DescribeEndpointRequest request) {
        return this.describeEndpointAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointResult> describeEndpointAsync(final DescribeEndpointRequest request, final AsyncHandler<DescribeEndpointRequest, DescribeEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEndpointResult>(){

            @Override
            public DescribeEndpointResult call() throws Exception {
                DescribeEndpointResult result;
                try {
                    result = AWSIotAsyncClient.this.describeEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeThingResult> describeThingAsync(DescribeThingRequest request) {
        return this.describeThingAsync(request, null);
    }

    @Override
    public Future<DescribeThingResult> describeThingAsync(final DescribeThingRequest request, final AsyncHandler<DescribeThingRequest, DescribeThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeThingResult>(){

            @Override
            public DescribeThingResult call() throws Exception {
                DescribeThingResult result;
                try {
                    result = AWSIotAsyncClient.this.describeThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachPrincipalPolicyResult> detachPrincipalPolicyAsync(DetachPrincipalPolicyRequest request) {
        return this.detachPrincipalPolicyAsync(request, null);
    }

    @Override
    public Future<DetachPrincipalPolicyResult> detachPrincipalPolicyAsync(final DetachPrincipalPolicyRequest request, final AsyncHandler<DetachPrincipalPolicyRequest, DetachPrincipalPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachPrincipalPolicyResult>(){

            @Override
            public DetachPrincipalPolicyResult call() throws Exception {
                DetachPrincipalPolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.detachPrincipalPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachThingPrincipalResult> detachThingPrincipalAsync(DetachThingPrincipalRequest request) {
        return this.detachThingPrincipalAsync(request, null);
    }

    @Override
    public Future<DetachThingPrincipalResult> detachThingPrincipalAsync(final DetachThingPrincipalRequest request, final AsyncHandler<DetachThingPrincipalRequest, DetachThingPrincipalResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachThingPrincipalResult>(){

            @Override
            public DetachThingPrincipalResult call() throws Exception {
                DetachThingPrincipalResult result;
                try {
                    result = AWSIotAsyncClient.this.detachThingPrincipal(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableTopicRuleResult> disableTopicRuleAsync(DisableTopicRuleRequest request) {
        return this.disableTopicRuleAsync(request, null);
    }

    @Override
    public Future<DisableTopicRuleResult> disableTopicRuleAsync(final DisableTopicRuleRequest request, final AsyncHandler<DisableTopicRuleRequest, DisableTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableTopicRuleResult>(){

            @Override
            public DisableTopicRuleResult call() throws Exception {
                DisableTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.disableTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableTopicRuleResult> enableTopicRuleAsync(EnableTopicRuleRequest request) {
        return this.enableTopicRuleAsync(request, null);
    }

    @Override
    public Future<EnableTopicRuleResult> enableTopicRuleAsync(final EnableTopicRuleRequest request, final AsyncHandler<EnableTopicRuleRequest, EnableTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableTopicRuleResult>(){

            @Override
            public EnableTopicRuleResult call() throws Exception {
                EnableTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.enableTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLoggingOptionsResult> getLoggingOptionsAsync(GetLoggingOptionsRequest request) {
        return this.getLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<GetLoggingOptionsResult> getLoggingOptionsAsync(final GetLoggingOptionsRequest request, final AsyncHandler<GetLoggingOptionsRequest, GetLoggingOptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetLoggingOptionsResult>(){

            @Override
            public GetLoggingOptionsResult call() throws Exception {
                GetLoggingOptionsResult result;
                try {
                    result = AWSIotAsyncClient.this.getLoggingOptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request) {
        return this.getPolicyAsync(request, null);
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(final GetPolicyRequest request, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result;
                try {
                    result = AWSIotAsyncClient.this.getPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyVersionResult> getPolicyVersionAsync(GetPolicyVersionRequest request) {
        return this.getPolicyVersionAsync(request, null);
    }

    @Override
    public Future<GetPolicyVersionResult> getPolicyVersionAsync(final GetPolicyVersionRequest request, final AsyncHandler<GetPolicyVersionRequest, GetPolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPolicyVersionResult>(){

            @Override
            public GetPolicyVersionResult call() throws Exception {
                GetPolicyVersionResult result;
                try {
                    result = AWSIotAsyncClient.this.getPolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRegistrationCodeResult> getRegistrationCodeAsync(GetRegistrationCodeRequest request) {
        return this.getRegistrationCodeAsync(request, null);
    }

    @Override
    public Future<GetRegistrationCodeResult> getRegistrationCodeAsync(final GetRegistrationCodeRequest request, final AsyncHandler<GetRegistrationCodeRequest, GetRegistrationCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRegistrationCodeResult>(){

            @Override
            public GetRegistrationCodeResult call() throws Exception {
                GetRegistrationCodeResult result;
                try {
                    result = AWSIotAsyncClient.this.getRegistrationCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTopicRuleResult> getTopicRuleAsync(GetTopicRuleRequest request) {
        return this.getTopicRuleAsync(request, null);
    }

    @Override
    public Future<GetTopicRuleResult> getTopicRuleAsync(final GetTopicRuleRequest request, final AsyncHandler<GetTopicRuleRequest, GetTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTopicRuleResult>(){

            @Override
            public GetTopicRuleResult call() throws Exception {
                GetTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.getTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCACertificatesResult> listCACertificatesAsync(ListCACertificatesRequest request) {
        return this.listCACertificatesAsync(request, null);
    }

    @Override
    public Future<ListCACertificatesResult> listCACertificatesAsync(final ListCACertificatesRequest request, final AsyncHandler<ListCACertificatesRequest, ListCACertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCACertificatesResult>(){

            @Override
            public ListCACertificatesResult call() throws Exception {
                ListCACertificatesResult result;
                try {
                    result = AWSIotAsyncClient.this.listCACertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(ListCertificatesRequest request) {
        return this.listCertificatesAsync(request, null);
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(final ListCertificatesRequest request, final AsyncHandler<ListCertificatesRequest, ListCertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCertificatesResult>(){

            @Override
            public ListCertificatesResult call() throws Exception {
                ListCertificatesResult result;
                try {
                    result = AWSIotAsyncClient.this.listCertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificatesByCAResult> listCertificatesByCAAsync(ListCertificatesByCARequest request) {
        return this.listCertificatesByCAAsync(request, null);
    }

    @Override
    public Future<ListCertificatesByCAResult> listCertificatesByCAAsync(final ListCertificatesByCARequest request, final AsyncHandler<ListCertificatesByCARequest, ListCertificatesByCAResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCertificatesByCAResult>(){

            @Override
            public ListCertificatesByCAResult call() throws Exception {
                ListCertificatesByCAResult result;
                try {
                    result = AWSIotAsyncClient.this.listCertificatesByCA(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request) {
        return this.listPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(final ListPoliciesRequest request, final AsyncHandler<ListPoliciesRequest, ListPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPoliciesResult>(){

            @Override
            public ListPoliciesResult call() throws Exception {
                ListPoliciesResult result;
                try {
                    result = AWSIotAsyncClient.this.listPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPolicyPrincipalsResult> listPolicyPrincipalsAsync(ListPolicyPrincipalsRequest request) {
        return this.listPolicyPrincipalsAsync(request, null);
    }

    @Override
    public Future<ListPolicyPrincipalsResult> listPolicyPrincipalsAsync(final ListPolicyPrincipalsRequest request, final AsyncHandler<ListPolicyPrincipalsRequest, ListPolicyPrincipalsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPolicyPrincipalsResult>(){

            @Override
            public ListPolicyPrincipalsResult call() throws Exception {
                ListPolicyPrincipalsResult result;
                try {
                    result = AWSIotAsyncClient.this.listPolicyPrincipals(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPolicyVersionsResult> listPolicyVersionsAsync(ListPolicyVersionsRequest request) {
        return this.listPolicyVersionsAsync(request, null);
    }

    @Override
    public Future<ListPolicyVersionsResult> listPolicyVersionsAsync(final ListPolicyVersionsRequest request, final AsyncHandler<ListPolicyVersionsRequest, ListPolicyVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPolicyVersionsResult>(){

            @Override
            public ListPolicyVersionsResult call() throws Exception {
                ListPolicyVersionsResult result;
                try {
                    result = AWSIotAsyncClient.this.listPolicyVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPrincipalPoliciesResult> listPrincipalPoliciesAsync(ListPrincipalPoliciesRequest request) {
        return this.listPrincipalPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPrincipalPoliciesResult> listPrincipalPoliciesAsync(final ListPrincipalPoliciesRequest request, final AsyncHandler<ListPrincipalPoliciesRequest, ListPrincipalPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPrincipalPoliciesResult>(){

            @Override
            public ListPrincipalPoliciesResult call() throws Exception {
                ListPrincipalPoliciesResult result;
                try {
                    result = AWSIotAsyncClient.this.listPrincipalPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPrincipalThingsResult> listPrincipalThingsAsync(ListPrincipalThingsRequest request) {
        return this.listPrincipalThingsAsync(request, null);
    }

    @Override
    public Future<ListPrincipalThingsResult> listPrincipalThingsAsync(final ListPrincipalThingsRequest request, final AsyncHandler<ListPrincipalThingsRequest, ListPrincipalThingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPrincipalThingsResult>(){

            @Override
            public ListPrincipalThingsResult call() throws Exception {
                ListPrincipalThingsResult result;
                try {
                    result = AWSIotAsyncClient.this.listPrincipalThings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListThingPrincipalsResult> listThingPrincipalsAsync(ListThingPrincipalsRequest request) {
        return this.listThingPrincipalsAsync(request, null);
    }

    @Override
    public Future<ListThingPrincipalsResult> listThingPrincipalsAsync(final ListThingPrincipalsRequest request, final AsyncHandler<ListThingPrincipalsRequest, ListThingPrincipalsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListThingPrincipalsResult>(){

            @Override
            public ListThingPrincipalsResult call() throws Exception {
                ListThingPrincipalsResult result;
                try {
                    result = AWSIotAsyncClient.this.listThingPrincipals(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListThingsResult> listThingsAsync(ListThingsRequest request) {
        return this.listThingsAsync(request, null);
    }

    @Override
    public Future<ListThingsResult> listThingsAsync(final ListThingsRequest request, final AsyncHandler<ListThingsRequest, ListThingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListThingsResult>(){

            @Override
            public ListThingsResult call() throws Exception {
                ListThingsResult result;
                try {
                    result = AWSIotAsyncClient.this.listThings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicRulesResult> listTopicRulesAsync(ListTopicRulesRequest request) {
        return this.listTopicRulesAsync(request, null);
    }

    @Override
    public Future<ListTopicRulesResult> listTopicRulesAsync(final ListTopicRulesRequest request, final AsyncHandler<ListTopicRulesRequest, ListTopicRulesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTopicRulesResult>(){

            @Override
            public ListTopicRulesResult call() throws Exception {
                ListTopicRulesResult result;
                try {
                    result = AWSIotAsyncClient.this.listTopicRules(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterCACertificateResult> registerCACertificateAsync(RegisterCACertificateRequest request) {
        return this.registerCACertificateAsync(request, null);
    }

    @Override
    public Future<RegisterCACertificateResult> registerCACertificateAsync(final RegisterCACertificateRequest request, final AsyncHandler<RegisterCACertificateRequest, RegisterCACertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterCACertificateResult>(){

            @Override
            public RegisterCACertificateResult call() throws Exception {
                RegisterCACertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.registerCACertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterCertificateResult> registerCertificateAsync(RegisterCertificateRequest request) {
        return this.registerCertificateAsync(request, null);
    }

    @Override
    public Future<RegisterCertificateResult> registerCertificateAsync(final RegisterCertificateRequest request, final AsyncHandler<RegisterCertificateRequest, RegisterCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterCertificateResult>(){

            @Override
            public RegisterCertificateResult call() throws Exception {
                RegisterCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.registerCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectCertificateTransferResult> rejectCertificateTransferAsync(RejectCertificateTransferRequest request) {
        return this.rejectCertificateTransferAsync(request, null);
    }

    @Override
    public Future<RejectCertificateTransferResult> rejectCertificateTransferAsync(final RejectCertificateTransferRequest request, final AsyncHandler<RejectCertificateTransferRequest, RejectCertificateTransferResult> asyncHandler) {
        return this.executorService.submit(new Callable<RejectCertificateTransferResult>(){

            @Override
            public RejectCertificateTransferResult call() throws Exception {
                RejectCertificateTransferResult result;
                try {
                    result = AWSIotAsyncClient.this.rejectCertificateTransfer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplaceTopicRuleResult> replaceTopicRuleAsync(ReplaceTopicRuleRequest request) {
        return this.replaceTopicRuleAsync(request, null);
    }

    @Override
    public Future<ReplaceTopicRuleResult> replaceTopicRuleAsync(final ReplaceTopicRuleRequest request, final AsyncHandler<ReplaceTopicRuleRequest, ReplaceTopicRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReplaceTopicRuleResult>(){

            @Override
            public ReplaceTopicRuleResult call() throws Exception {
                ReplaceTopicRuleResult result;
                try {
                    result = AWSIotAsyncClient.this.replaceTopicRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetDefaultPolicyVersionResult> setDefaultPolicyVersionAsync(SetDefaultPolicyVersionRequest request) {
        return this.setDefaultPolicyVersionAsync(request, null);
    }

    @Override
    public Future<SetDefaultPolicyVersionResult> setDefaultPolicyVersionAsync(final SetDefaultPolicyVersionRequest request, final AsyncHandler<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetDefaultPolicyVersionResult>(){

            @Override
            public SetDefaultPolicyVersionResult call() throws Exception {
                SetDefaultPolicyVersionResult result;
                try {
                    result = AWSIotAsyncClient.this.setDefaultPolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetLoggingOptionsResult> setLoggingOptionsAsync(SetLoggingOptionsRequest request) {
        return this.setLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<SetLoggingOptionsResult> setLoggingOptionsAsync(final SetLoggingOptionsRequest request, final AsyncHandler<SetLoggingOptionsRequest, SetLoggingOptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetLoggingOptionsResult>(){

            @Override
            public SetLoggingOptionsResult call() throws Exception {
                SetLoggingOptionsResult result;
                try {
                    result = AWSIotAsyncClient.this.setLoggingOptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TransferCertificateResult> transferCertificateAsync(TransferCertificateRequest request) {
        return this.transferCertificateAsync(request, null);
    }

    @Override
    public Future<TransferCertificateResult> transferCertificateAsync(final TransferCertificateRequest request, final AsyncHandler<TransferCertificateRequest, TransferCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<TransferCertificateResult>(){

            @Override
            public TransferCertificateResult call() throws Exception {
                TransferCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.transferCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCACertificateResult> updateCACertificateAsync(UpdateCACertificateRequest request) {
        return this.updateCACertificateAsync(request, null);
    }

    @Override
    public Future<UpdateCACertificateResult> updateCACertificateAsync(final UpdateCACertificateRequest request, final AsyncHandler<UpdateCACertificateRequest, UpdateCACertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateCACertificateResult>(){

            @Override
            public UpdateCACertificateResult call() throws Exception {
                UpdateCACertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.updateCACertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCertificateResult> updateCertificateAsync(UpdateCertificateRequest request) {
        return this.updateCertificateAsync(request, null);
    }

    @Override
    public Future<UpdateCertificateResult> updateCertificateAsync(final UpdateCertificateRequest request, final AsyncHandler<UpdateCertificateRequest, UpdateCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateCertificateResult>(){

            @Override
            public UpdateCertificateResult call() throws Exception {
                UpdateCertificateResult result;
                try {
                    result = AWSIotAsyncClient.this.updateCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateThingResult> updateThingAsync(UpdateThingRequest request) {
        return this.updateThingAsync(request, null);
    }

    @Override
    public Future<UpdateThingResult> updateThingAsync(final UpdateThingRequest request, final AsyncHandler<UpdateThingRequest, UpdateThingResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateThingResult>(){

            @Override
            public UpdateThingResult call() throws Exception {
                UpdateThingResult result;
                try {
                    result = AWSIotAsyncClient.this.updateThing(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

