/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class TopicRulePayloadJsonMarshaller {
    private static TopicRulePayloadJsonMarshaller instance;

    public void marshall(TopicRulePayload topicRulePayload, StructuredJsonGenerator jsonGenerator) {
        if (topicRulePayload == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Action> actionsList;
            jsonGenerator.writeStartObject();
            if (topicRulePayload.getSql() != null) {
                jsonGenerator.writeFieldName("sql").writeValue(topicRulePayload.getSql());
            }
            if (topicRulePayload.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(topicRulePayload.getDescription());
            }
            if ((actionsList = topicRulePayload.getActions()) != null) {
                jsonGenerator.writeFieldName("actions");
                jsonGenerator.writeStartArray();
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (topicRulePayload.getRuleDisabled() != null) {
                jsonGenerator.writeFieldName("ruleDisabled").writeValue(topicRulePayload.getRuleDisabled().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TopicRulePayloadJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRulePayloadJsonMarshaller();
        }
        return instance;
    }
}

