/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListCertificatesRequestMarshaller
implements Marshaller<Request<ListCertificatesRequest>, ListCertificatesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListCertificatesRequest> marshall(ListCertificatesRequest listCertificatesRequest) {
        String ascendingOrder;
        String marker;
        String pageSize;
        if (listCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCertificatesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/certificates";
        request.setResourcePath(uriResourcePath);
        String string = pageSize = listCertificatesRequest.getPageSize() == null ? null : StringUtils.fromInteger((Integer)listCertificatesRequest.getPageSize());
        if (pageSize != null) {
            request.addParameter("pageSize", pageSize);
        }
        String string2 = marker = listCertificatesRequest.getMarker() == null ? null : StringUtils.fromString((String)listCertificatesRequest.getMarker());
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        String string3 = ascendingOrder = listCertificatesRequest.getAscendingOrder() == null ? null : StringUtils.fromBoolean((Boolean)listCertificatesRequest.getAscendingOrder());
        if (ascendingOrder != null) {
            request.addParameter("isAscendingOrder", ascendingOrder);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

