/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.inspector2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * VulnerabilityMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class VulnerabilityMarshaller {

    private static final MarshallingInfo<StructuredPojo> ATIGDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("atigData").build();
    private static final MarshallingInfo<StructuredPojo> CISADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cisaData").build();
    private static final MarshallingInfo<StructuredPojo> CVSS2_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cvss2").build();
    private static final MarshallingInfo<StructuredPojo> CVSS3_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cvss3").build();
    private static final MarshallingInfo<List> CWES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cwes").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> DETECTIONPLATFORMS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectionPlatforms").build();
    private static final MarshallingInfo<StructuredPojo> EPSS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("epss").build();
    private static final MarshallingInfo<StructuredPojo> EXPLOITOBSERVED_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exploitObserved").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("id").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("referenceUrls").build();
    private static final MarshallingInfo<List> RELATEDVULNERABILITIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedVulnerabilities").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("source").build();
    private static final MarshallingInfo<String> SOURCEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("sourceUrl").build();
    private static final MarshallingInfo<java.util.Date> VENDORCREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorCreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VENDORSEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorSeverity").build();
    private static final MarshallingInfo<java.util.Date> VENDORUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorUpdatedAt").timestampFormat("unixTimestamp").build();

    private static final VulnerabilityMarshaller instance = new VulnerabilityMarshaller();

    public static VulnerabilityMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Vulnerability vulnerability, ProtocolMarshaller protocolMarshaller) {

        if (vulnerability == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(vulnerability.getAtigData(), ATIGDATA_BINDING);
            protocolMarshaller.marshall(vulnerability.getCisaData(), CISADATA_BINDING);
            protocolMarshaller.marshall(vulnerability.getCvss2(), CVSS2_BINDING);
            protocolMarshaller.marshall(vulnerability.getCvss3(), CVSS3_BINDING);
            protocolMarshaller.marshall(vulnerability.getCwes(), CWES_BINDING);
            protocolMarshaller.marshall(vulnerability.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(vulnerability.getDetectionPlatforms(), DETECTIONPLATFORMS_BINDING);
            protocolMarshaller.marshall(vulnerability.getEpss(), EPSS_BINDING);
            protocolMarshaller.marshall(vulnerability.getExploitObserved(), EXPLOITOBSERVED_BINDING);
            protocolMarshaller.marshall(vulnerability.getId(), ID_BINDING);
            protocolMarshaller.marshall(vulnerability.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall(vulnerability.getRelatedVulnerabilities(), RELATEDVULNERABILITIES_BINDING);
            protocolMarshaller.marshall(vulnerability.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(vulnerability.getSourceUrl(), SOURCEURL_BINDING);
            protocolMarshaller.marshall(vulnerability.getVendorCreatedAt(), VENDORCREATEDAT_BINDING);
            protocolMarshaller.marshall(vulnerability.getVendorSeverity(), VENDORSEVERITY_BINDING);
            protocolMarshaller.marshall(vulnerability.getVendorUpdatedAt(), VENDORUPDATEDAT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
