/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2;

import javax.annotation.Generated;

import com.amazonaws.services.inspector2.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSInspector2}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSInspector2 implements AWSInspector2 {

    protected AbstractAWSInspector2() {
    }

    @Override
    public AssociateMemberResult associateMember(AssociateMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetAccountStatusResult batchGetAccountStatus(BatchGetAccountStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetCodeSnippetResult batchGetCodeSnippet(BatchGetCodeSnippetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetFindingDetailsResult batchGetFindingDetails(BatchGetFindingDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetFreeTrialInfoResult batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetMemberEc2DeepInspectionStatusResult batchGetMemberEc2DeepInspectionStatus(BatchGetMemberEc2DeepInspectionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateMemberEc2DeepInspectionStatusResult batchUpdateMemberEc2DeepInspectionStatus(BatchUpdateMemberEc2DeepInspectionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelFindingsReportResult cancelFindingsReport(CancelFindingsReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelSbomExportResult cancelSbomExport(CancelSbomExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCisScanConfigurationResult createCisScanConfiguration(CreateCisScanConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFilterResult createFilter(CreateFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFindingsReportResult createFindingsReport(CreateFindingsReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSbomExportResult createSbomExport(CreateSbomExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCisScanConfigurationResult deleteCisScanConfiguration(DeleteCisScanConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFilterResult deleteFilter(DeleteFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationConfigurationResult describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableResult disable(DisableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableDelegatedAdminAccountResult disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberResult disassociateMember(DisassociateMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableResult enable(EnableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableDelegatedAdminAccountResult enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCisScanReportResult getCisScanReport(GetCisScanReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCisScanResultDetailsResult getCisScanResultDetails(GetCisScanResultDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfigurationResult getConfiguration(GetConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDelegatedAdminAccountResult getDelegatedAdminAccount(GetDelegatedAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEc2DeepInspectionConfigurationResult getEc2DeepInspectionConfiguration(GetEc2DeepInspectionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEncryptionKeyResult getEncryptionKey(GetEncryptionKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsReportStatusResult getFindingsReportStatus(GetFindingsReportStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMemberResult getMember(GetMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSbomExportResult getSbomExport(GetSbomExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountPermissionsResult listAccountPermissions(ListAccountPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCisScanConfigurationsResult listCisScanConfigurations(ListCisScanConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCisScanResultsAggregatedByChecksResult listCisScanResultsAggregatedByChecks(ListCisScanResultsAggregatedByChecksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCisScanResultsAggregatedByTargetResourceResult listCisScanResultsAggregatedByTargetResource(
            ListCisScanResultsAggregatedByTargetResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCisScansResult listCisScans(ListCisScansRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoverageResult listCoverage(ListCoverageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoverageStatisticsResult listCoverageStatistics(ListCoverageStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDelegatedAdminAccountsResult listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFiltersResult listFilters(ListFiltersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingAggregationsResult listFindingAggregations(ListFindingAggregationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingsResult listFindings(ListFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsageTotalsResult listUsageTotals(ListUsageTotalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetEncryptionKeyResult resetEncryptionKey(ResetEncryptionKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchVulnerabilitiesResult searchVulnerabilities(SearchVulnerabilitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendCisSessionHealthResult sendCisSessionHealth(SendCisSessionHealthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendCisSessionTelemetryResult sendCisSessionTelemetry(SendCisSessionTelemetryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartCisSessionResult startCisSession(StartCisSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopCisSessionResult stopCisSession(StopCisSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCisScanConfigurationResult updateCisScanConfiguration(UpdateCisScanConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfigurationResult updateConfiguration(UpdateConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEc2DeepInspectionConfigurationResult updateEc2DeepInspectionConfiguration(UpdateEc2DeepInspectionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEncryptionKeyResult updateEncryptionKey(UpdateEncryptionKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFilterResult updateFilter(UpdateFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOrgEc2DeepInspectionConfigurationResult updateOrgEc2DeepInspectionConfiguration(UpdateOrgEc2DeepInspectionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOrganizationConfigurationResult updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
