/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains information on the lines of code associated with a code snippet.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CodeLine" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CodeLine implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The content of a line of code
     * </p>
     */
    private String content;
    /**
     * <p>
     * The line number that a section of code is located at.
     * </p>
     */
    private Integer lineNumber;

    /**
     * <p>
     * The content of a line of code
     * </p>
     * 
     * @param content
     *        The content of a line of code
     */

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * <p>
     * The content of a line of code
     * </p>
     * 
     * @return The content of a line of code
     */

    public String getContent() {
        return this.content;
    }

    /**
     * <p>
     * The content of a line of code
     * </p>
     * 
     * @param content
     *        The content of a line of code
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeLine withContent(String content) {
        setContent(content);
        return this;
    }

    /**
     * <p>
     * The line number that a section of code is located at.
     * </p>
     * 
     * @param lineNumber
     *        The line number that a section of code is located at.
     */

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    /**
     * <p>
     * The line number that a section of code is located at.
     * </p>
     * 
     * @return The line number that a section of code is located at.
     */

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    /**
     * <p>
     * The line number that a section of code is located at.
     * </p>
     * 
     * @param lineNumber
     *        The line number that a section of code is located at.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeLine withLineNumber(Integer lineNumber) {
        setLineNumber(lineNumber);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getContent() != null)
            sb.append("Content: ").append(getContent()).append(",");
        if (getLineNumber() != null)
            sb.append("LineNumber: ").append(getLineNumber());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CodeLine == false)
            return false;
        CodeLine other = (CodeLine) obj;
        if (other.getContent() == null ^ this.getContent() == null)
            return false;
        if (other.getContent() != null && other.getContent().equals(this.getContent()) == false)
            return false;
        if (other.getLineNumber() == null ^ this.getLineNumber() == null)
            return false;
        if (other.getLineNumber() != null && other.getLineNumber().equals(this.getLineNumber()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getContent() == null) ? 0 : getContent().hashCode());
        hashCode = prime * hashCode + ((getLineNumber() == null) ? 0 : getLineNumber().hashCode());
        return hashCode;
    }

    @Override
    public CodeLine clone() {
        try {
            return (CodeLine) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.inspector2.model.transform.CodeLineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
