/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector2.model.ResourceStatus;

@SdkInternalApi
public class ResourceStatusMarshaller {
    private static final MarshallingInfo<String> EC2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2").build();
    private static final MarshallingInfo<String> ECR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ecr").build();
    private static final ResourceStatusMarshaller instance = new ResourceStatusMarshaller();

    public static ResourceStatusMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceStatus resourceStatus, ProtocolMarshaller protocolMarshaller) {
        if (resourceStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceStatus.getEc2(), EC2_BINDING);
            protocolMarshaller.marshall((Object)resourceStatus.getEcr(), ECR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

