/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeResourceGroupsRequestMarshaller
implements Marshaller<Request<DescribeResourceGroupsRequest>, DescribeResourceGroupsRequest> {
    public Request<DescribeResourceGroupsRequest> marshall(DescribeResourceGroupsRequest describeResourceGroupsRequest) {
        if (describeResourceGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeResourceGroupsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeResourceGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            List<String> resourceGroupArnsList = describeResourceGroupsRequest.getResourceGroupArns();
            if (resourceGroupArnsList != null) {
                jsonGenerator.writeFieldName("resourceGroupArns");
                jsonGenerator.writeStartArray();
                for (String resourceGroupArnsListValue : resourceGroupArnsList) {
                    if (resourceGroupArnsListValue == null) continue;
                    jsonGenerator.writeValue(resourceGroupArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

