/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.imagebuilder.model.ImagePackage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListImagePackagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String requestId;
    private List<ImagePackage> imagePackageList;
    private String nextToken;

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ListImagePackagesResult withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public List<ImagePackage> getImagePackageList() {
        return this.imagePackageList;
    }

    public void setImagePackageList(Collection<ImagePackage> imagePackageList) {
        if (imagePackageList == null) {
            this.imagePackageList = null;
            return;
        }
        this.imagePackageList = new ArrayList<ImagePackage>(imagePackageList);
    }

    public ListImagePackagesResult withImagePackageList(ImagePackage ... imagePackageList) {
        if (this.imagePackageList == null) {
            this.setImagePackageList(new ArrayList<ImagePackage>(imagePackageList.length));
        }
        for (ImagePackage ele : imagePackageList) {
            this.imagePackageList.add(ele);
        }
        return this;
    }

    public ListImagePackagesResult withImagePackageList(Collection<ImagePackage> imagePackageList) {
        this.setImagePackageList(imagePackageList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListImagePackagesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getImagePackageList() != null) {
            sb.append("ImagePackageList: ").append(this.getImagePackageList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagePackagesResult)) {
            return false;
        }
        ListImagePackagesResult other = (ListImagePackagesResult)obj;
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getImagePackageList() == null ^ this.getImagePackageList() == null) {
            return false;
        }
        if (other.getImagePackageList() != null && !other.getImagePackageList().equals(this.getImagePackageList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getImagePackageList() == null ? 0 : this.getImagePackageList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListImagePackagesResult clone() {
        try {
            return (ListImagePackagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

