/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.imagebuilder.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * WorkflowStepExecutionMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class WorkflowStepExecutionMarshaller {

    private static final MarshallingInfo<String> STEPEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stepExecutionId").build();
    private static final MarshallingInfo<String> IMAGEBUILDVERSIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageBuildVersionArn").build();
    private static final MarshallingInfo<String> WORKFLOWEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionId").build();
    private static final MarshallingInfo<String> WORKFLOWBUILDVERSIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowBuildVersionArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("name").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("action").build();
    private static final MarshallingInfo<String> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startTime").build();

    private static final WorkflowStepExecutionMarshaller instance = new WorkflowStepExecutionMarshaller();

    public static WorkflowStepExecutionMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(WorkflowStepExecution workflowStepExecution, ProtocolMarshaller protocolMarshaller) {

        if (workflowStepExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(workflowStepExecution.getStepExecutionId(), STEPEXECUTIONID_BINDING);
            protocolMarshaller.marshall(workflowStepExecution.getImageBuildVersionArn(), IMAGEBUILDVERSIONARN_BINDING);
            protocolMarshaller.marshall(workflowStepExecution.getWorkflowExecutionId(), WORKFLOWEXECUTIONID_BINDING);
            protocolMarshaller.marshall(workflowStepExecution.getWorkflowBuildVersionArn(), WORKFLOWBUILDVERSIONARN_BINDING);
            protocolMarshaller.marshall(workflowStepExecution.getName(), NAME_BINDING);
            protocolMarshaller.marshall(workflowStepExecution.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall(workflowStepExecution.getStartTime(), STARTTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
