/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.Image;
import java.util.Map;

@SdkInternalApi
public class ImageMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<Boolean> ENHANCEDIMAGEMETADATAENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enhancedImageMetadataEnabled").build();
    private static final MarshallingInfo<String> OSVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("osVersion").build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<StructuredPojo> IMAGERECIPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageRecipe").build();
    private static final MarshallingInfo<StructuredPojo> CONTAINERRECIPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerRecipe").build();
    private static final MarshallingInfo<String> SOURCEPIPELINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourcePipelineName").build();
    private static final MarshallingInfo<String> SOURCEPIPELINEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourcePipelineArn").build();
    private static final MarshallingInfo<StructuredPojo> INFRASTRUCTURECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("infrastructureConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> DISTRIBUTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distributionConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> IMAGETESTSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTestsConfiguration").build();
    private static final MarshallingInfo<String> DATECREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dateCreated").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputResources").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> BUILDTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildType").build();
    private static final MarshallingInfo<String> IMAGESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageSource").build();
    private static final MarshallingInfo<StructuredPojo> SCANSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanState").build();
    private static final MarshallingInfo<StructuredPojo> IMAGESCANNINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageScanningConfiguration").build();
    private static final ImageMarshaller instance = new ImageMarshaller();

    public static ImageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Image image, ProtocolMarshaller protocolMarshaller) {
        if (image == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)image.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)image.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)image.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)image.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)image.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)image.getEnhancedImageMetadataEnabled(), ENHANCEDIMAGEMETADATAENABLED_BINDING);
            protocolMarshaller.marshall((Object)image.getOsVersion(), OSVERSION_BINDING);
            protocolMarshaller.marshall((Object)image.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)image.getImageRecipe(), IMAGERECIPE_BINDING);
            protocolMarshaller.marshall((Object)image.getContainerRecipe(), CONTAINERRECIPE_BINDING);
            protocolMarshaller.marshall((Object)image.getSourcePipelineName(), SOURCEPIPELINENAME_BINDING);
            protocolMarshaller.marshall((Object)image.getSourcePipelineArn(), SOURCEPIPELINEARN_BINDING);
            protocolMarshaller.marshall((Object)image.getInfrastructureConfiguration(), INFRASTRUCTURECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)image.getDistributionConfiguration(), DISTRIBUTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)image.getImageTestsConfiguration(), IMAGETESTSCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)image.getDateCreated(), DATECREATED_BINDING);
            protocolMarshaller.marshall((Object)image.getOutputResources(), OUTPUTRESOURCES_BINDING);
            protocolMarshaller.marshall(image.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)image.getBuildType(), BUILDTYPE_BINDING);
            protocolMarshaller.marshall((Object)image.getImageSource(), IMAGESOURCE_BINDING);
            protocolMarshaller.marshall((Object)image.getScanState(), SCANSTATE_BINDING);
            protocolMarshaller.marshall((Object)image.getImageScanningConfiguration(), IMAGESCANNINGCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

