/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.imagebuilder.model.ComponentConfiguration;
import com.amazonaws.services.imagebuilder.model.ContainerType;
import com.amazonaws.services.imagebuilder.model.Platform;
import com.amazonaws.services.imagebuilder.model.TargetContainerRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateContainerRecipeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String containerType;
    private String name;
    private String description;
    private String semanticVersion;
    private List<ComponentConfiguration> components;
    private String dockerfileTemplateData;
    private String dockerfileTemplateUri;
    private String platformOverride;
    private String imageOsVersionOverride;
    private String parentImage;
    private Map<String, String> tags;
    private String workingDirectory;
    private TargetContainerRepository targetRepository;
    private String kmsKeyId;
    private String clientToken;

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public CreateContainerRecipeRequest withContainerType(String containerType) {
        this.setContainerType(containerType);
        return this;
    }

    public CreateContainerRecipeRequest withContainerType(ContainerType containerType) {
        this.containerType = containerType.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateContainerRecipeRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateContainerRecipeRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSemanticVersion(String semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    public String getSemanticVersion() {
        return this.semanticVersion;
    }

    public CreateContainerRecipeRequest withSemanticVersion(String semanticVersion) {
        this.setSemanticVersion(semanticVersion);
        return this;
    }

    public List<ComponentConfiguration> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<ComponentConfiguration> components) {
        if (components == null) {
            this.components = null;
            return;
        }
        this.components = new ArrayList<ComponentConfiguration>(components);
    }

    public CreateContainerRecipeRequest withComponents(ComponentConfiguration ... components) {
        if (this.components == null) {
            this.setComponents(new ArrayList<ComponentConfiguration>(components.length));
        }
        for (ComponentConfiguration ele : components) {
            this.components.add(ele);
        }
        return this;
    }

    public CreateContainerRecipeRequest withComponents(Collection<ComponentConfiguration> components) {
        this.setComponents(components);
        return this;
    }

    public void setDockerfileTemplateData(String dockerfileTemplateData) {
        this.dockerfileTemplateData = dockerfileTemplateData;
    }

    public String getDockerfileTemplateData() {
        return this.dockerfileTemplateData;
    }

    public CreateContainerRecipeRequest withDockerfileTemplateData(String dockerfileTemplateData) {
        this.setDockerfileTemplateData(dockerfileTemplateData);
        return this;
    }

    public void setDockerfileTemplateUri(String dockerfileTemplateUri) {
        this.dockerfileTemplateUri = dockerfileTemplateUri;
    }

    public String getDockerfileTemplateUri() {
        return this.dockerfileTemplateUri;
    }

    public CreateContainerRecipeRequest withDockerfileTemplateUri(String dockerfileTemplateUri) {
        this.setDockerfileTemplateUri(dockerfileTemplateUri);
        return this;
    }

    public void setPlatformOverride(String platformOverride) {
        this.platformOverride = platformOverride;
    }

    public String getPlatformOverride() {
        return this.platformOverride;
    }

    public CreateContainerRecipeRequest withPlatformOverride(String platformOverride) {
        this.setPlatformOverride(platformOverride);
        return this;
    }

    public CreateContainerRecipeRequest withPlatformOverride(Platform platformOverride) {
        this.platformOverride = platformOverride.toString();
        return this;
    }

    public void setImageOsVersionOverride(String imageOsVersionOverride) {
        this.imageOsVersionOverride = imageOsVersionOverride;
    }

    public String getImageOsVersionOverride() {
        return this.imageOsVersionOverride;
    }

    public CreateContainerRecipeRequest withImageOsVersionOverride(String imageOsVersionOverride) {
        this.setImageOsVersionOverride(imageOsVersionOverride);
        return this;
    }

    public void setParentImage(String parentImage) {
        this.parentImage = parentImage;
    }

    public String getParentImage() {
        return this.parentImage;
    }

    public CreateContainerRecipeRequest withParentImage(String parentImage) {
        this.setParentImage(parentImage);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateContainerRecipeRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateContainerRecipeRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateContainerRecipeRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public CreateContainerRecipeRequest withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public void setTargetRepository(TargetContainerRepository targetRepository) {
        this.targetRepository = targetRepository;
    }

    public TargetContainerRepository getTargetRepository() {
        return this.targetRepository;
    }

    public CreateContainerRecipeRequest withTargetRepository(TargetContainerRepository targetRepository) {
        this.setTargetRepository(targetRepository);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateContainerRecipeRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateContainerRecipeRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerType() != null) {
            sb.append("ContainerType: ").append(this.getContainerType()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSemanticVersion() != null) {
            sb.append("SemanticVersion: ").append(this.getSemanticVersion()).append(",");
        }
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents()).append(",");
        }
        if (this.getDockerfileTemplateData() != null) {
            sb.append("DockerfileTemplateData: ").append(this.getDockerfileTemplateData()).append(",");
        }
        if (this.getDockerfileTemplateUri() != null) {
            sb.append("DockerfileTemplateUri: ").append(this.getDockerfileTemplateUri()).append(",");
        }
        if (this.getPlatformOverride() != null) {
            sb.append("PlatformOverride: ").append(this.getPlatformOverride()).append(",");
        }
        if (this.getImageOsVersionOverride() != null) {
            sb.append("ImageOsVersionOverride: ").append(this.getImageOsVersionOverride()).append(",");
        }
        if (this.getParentImage() != null) {
            sb.append("ParentImage: ").append(this.getParentImage()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getTargetRepository() != null) {
            sb.append("TargetRepository: ").append(this.getTargetRepository()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerRecipeRequest)) {
            return false;
        }
        CreateContainerRecipeRequest other = (CreateContainerRecipeRequest)obj;
        if (other.getContainerType() == null ^ this.getContainerType() == null) {
            return false;
        }
        if (other.getContainerType() != null && !other.getContainerType().equals(this.getContainerType())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSemanticVersion() == null ^ this.getSemanticVersion() == null) {
            return false;
        }
        if (other.getSemanticVersion() != null && !other.getSemanticVersion().equals(this.getSemanticVersion())) {
            return false;
        }
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        if (other.getComponents() != null && !other.getComponents().equals(this.getComponents())) {
            return false;
        }
        if (other.getDockerfileTemplateData() == null ^ this.getDockerfileTemplateData() == null) {
            return false;
        }
        if (other.getDockerfileTemplateData() != null && !other.getDockerfileTemplateData().equals(this.getDockerfileTemplateData())) {
            return false;
        }
        if (other.getDockerfileTemplateUri() == null ^ this.getDockerfileTemplateUri() == null) {
            return false;
        }
        if (other.getDockerfileTemplateUri() != null && !other.getDockerfileTemplateUri().equals(this.getDockerfileTemplateUri())) {
            return false;
        }
        if (other.getPlatformOverride() == null ^ this.getPlatformOverride() == null) {
            return false;
        }
        if (other.getPlatformOverride() != null && !other.getPlatformOverride().equals(this.getPlatformOverride())) {
            return false;
        }
        if (other.getImageOsVersionOverride() == null ^ this.getImageOsVersionOverride() == null) {
            return false;
        }
        if (other.getImageOsVersionOverride() != null && !other.getImageOsVersionOverride().equals(this.getImageOsVersionOverride())) {
            return false;
        }
        if (other.getParentImage() == null ^ this.getParentImage() == null) {
            return false;
        }
        if (other.getParentImage() != null && !other.getParentImage().equals(this.getParentImage())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getTargetRepository() == null ^ this.getTargetRepository() == null) {
            return false;
        }
        if (other.getTargetRepository() != null && !other.getTargetRepository().equals(this.getTargetRepository())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerType() == null ? 0 : this.getContainerType().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSemanticVersion() == null ? 0 : this.getSemanticVersion().hashCode());
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        hashCode = 31 * hashCode + (this.getDockerfileTemplateData() == null ? 0 : this.getDockerfileTemplateData().hashCode());
        hashCode = 31 * hashCode + (this.getDockerfileTemplateUri() == null ? 0 : this.getDockerfileTemplateUri().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformOverride() == null ? 0 : this.getPlatformOverride().hashCode());
        hashCode = 31 * hashCode + (this.getImageOsVersionOverride() == null ? 0 : this.getImageOsVersionOverride().hashCode());
        hashCode = 31 * hashCode + (this.getParentImage() == null ? 0 : this.getParentImage().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRepository() == null ? 0 : this.getTargetRepository().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateContainerRecipeRequest clone() {
        return (CreateContainerRecipeRequest)super.clone();
    }
}

