/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.transform.LaunchPermissionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LaunchPermissionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> userIds;
    private List<String> userGroups;

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        this.userIds = new ArrayList<String>(userIds);
    }

    public LaunchPermissionConfiguration withUserIds(String ... userIds) {
        if (this.userIds == null) {
            this.setUserIds(new ArrayList<String>(userIds.length));
        }
        for (String ele : userIds) {
            this.userIds.add(ele);
        }
        return this;
    }

    public LaunchPermissionConfiguration withUserIds(Collection<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public List<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Collection<String> userGroups) {
        if (userGroups == null) {
            this.userGroups = null;
            return;
        }
        this.userGroups = new ArrayList<String>(userGroups);
    }

    public LaunchPermissionConfiguration withUserGroups(String ... userGroups) {
        if (this.userGroups == null) {
            this.setUserGroups(new ArrayList<String>(userGroups.length));
        }
        for (String ele : userGroups) {
            this.userGroups.add(ele);
        }
        return this;
    }

    public LaunchPermissionConfiguration withUserGroups(Collection<String> userGroups) {
        this.setUserGroups(userGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserIds() != null) {
            sb.append("UserIds: ").append(this.getUserIds()).append(",");
        }
        if (this.getUserGroups() != null) {
            sb.append("UserGroups: ").append(this.getUserGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionConfiguration)) {
            return false;
        }
        LaunchPermissionConfiguration other = (LaunchPermissionConfiguration)obj;
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        if (other.getUserIds() != null && !other.getUserIds().equals(this.getUserIds())) {
            return false;
        }
        if (other.getUserGroups() == null ^ this.getUserGroups() == null) {
            return false;
        }
        return other.getUserGroups() == null || other.getUserGroups().equals(this.getUserGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getUserGroups() == null ? 0 : this.getUserGroups().hashCode());
        return hashCode;
    }

    public LaunchPermissionConfiguration clone() {
        try {
            return (LaunchPermissionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchPermissionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

