/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iamrolesanywhere.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iamrolesanywhere.model.InstanceProperty;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class InstancePropertyMarshaller {
    private static final MarshallingInfo<Boolean> FAILED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failed").build();
    private static final MarshallingInfo<Map> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("properties").build();
    private static final MarshallingInfo<Date> SEENAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("seenAt").timestampFormat("iso8601").build();
    private static final InstancePropertyMarshaller instance = new InstancePropertyMarshaller();

    public static InstancePropertyMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceProperty instanceProperty, ProtocolMarshaller protocolMarshaller) {
        if (instanceProperty == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceProperty.getFailed(), FAILED_BINDING);
            protocolMarshaller.marshall(instanceProperty.getProperties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)instanceProperty.getSeenAt(), SEENAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

