/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Role;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListRolesResult
implements Serializable,
Cloneable {
    private SdkInternalList<Role> roles;
    private Boolean isTruncated;
    private String marker;

    public List<Role> getRoles() {
        if (this.roles == null) {
            this.roles = new SdkInternalList();
        }
        return this.roles;
    }

    public void setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        this.roles = new SdkInternalList(roles);
    }

    public ListRolesResult withRoles(Role ... roles) {
        if (this.roles == null) {
            this.setRoles((Collection<Role>)new SdkInternalList(roles.length));
        }
        for (Role ele : roles) {
            this.roles.add((Object)ele);
        }
        return this;
    }

    public ListRolesResult withRoles(Collection<Role> roles) {
        this.setRoles(roles);
        return this;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public ListRolesResult withIsTruncated(Boolean isTruncated) {
        this.setIsTruncated(isTruncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListRolesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoles() != null) {
            sb.append("Roles: " + this.getRoles() + ",");
        }
        if (this.getIsTruncated() != null) {
            sb.append("IsTruncated: " + this.getIsTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRolesResult)) {
            return false;
        }
        ListRolesResult other = (ListRolesResult)obj;
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !other.getRoles().equals(this.getRoles())) {
            return false;
        }
        if (other.getIsTruncated() == null ^ this.getIsTruncated() == null) {
            return false;
        }
        if (other.getIsTruncated() != null && !other.getIsTruncated().equals(this.getIsTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        hashCode = 31 * hashCode + (this.getIsTruncated() == null ? 0 : this.getIsTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListRolesResult clone() {
        try {
            return (ListRolesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

