/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.DateTimeRange;
import com.amazonaws.services.health.model.EventFilter;
import com.amazonaws.services.health.model.transform.DateTimeRangeJsonMarshaller;
import java.util.List;
import java.util.Map;

public class EventFilterJsonMarshaller {
    private static EventFilterJsonMarshaller instance;

    public void marshall(EventFilter eventFilter, StructuredJsonGenerator jsonGenerator) {
        if (eventFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<Map<String, String>> list2;
            List<String> list3;
            List<String> list4;
            List<String> list5;
            List<DateTimeRange> list6;
            List<DateTimeRange> list7;
            List<DateTimeRange> list8;
            List<String> list9;
            List<String> list10;
            List<String> list11;
            List<String> eventTypeCodesList;
            jsonGenerator.writeStartObject();
            List<String> eventArnsList = eventFilter.getEventArns();
            if (eventArnsList != null) {
                jsonGenerator.writeFieldName("eventArns");
                jsonGenerator.writeStartArray();
                for (String string : eventArnsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((eventTypeCodesList = eventFilter.getEventTypeCodes()) != null) {
                jsonGenerator.writeFieldName("eventTypeCodes");
                jsonGenerator.writeStartArray();
                for (String string : eventTypeCodesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list11 = eventFilter.getServices()) != null) {
                jsonGenerator.writeFieldName("services");
                jsonGenerator.writeStartArray();
                for (String string : list11) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list10 = eventFilter.getRegions()) != null) {
                jsonGenerator.writeFieldName("regions");
                jsonGenerator.writeStartArray();
                for (String string : list10) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list9 = eventFilter.getAvailabilityZones()) != null) {
                jsonGenerator.writeFieldName("availabilityZones");
                jsonGenerator.writeStartArray();
                for (String string : list9) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list8 = eventFilter.getStartTimes()) != null) {
                jsonGenerator.writeFieldName("startTimes");
                jsonGenerator.writeStartArray();
                for (DateTimeRange dateTimeRange : list8) {
                    if (dateTimeRange == null) continue;
                    DateTimeRangeJsonMarshaller.getInstance().marshall(dateTimeRange, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list7 = eventFilter.getEndTimes()) != null) {
                jsonGenerator.writeFieldName("endTimes");
                jsonGenerator.writeStartArray();
                for (DateTimeRange dateTimeRange : list7) {
                    if (dateTimeRange == null) continue;
                    DateTimeRangeJsonMarshaller.getInstance().marshall(dateTimeRange, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list6 = eventFilter.getLastUpdatedTimes()) != null) {
                jsonGenerator.writeFieldName("lastUpdatedTimes");
                jsonGenerator.writeStartArray();
                for (DateTimeRange dateTimeRange : list6) {
                    if (dateTimeRange == null) continue;
                    DateTimeRangeJsonMarshaller.getInstance().marshall(dateTimeRange, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list5 = eventFilter.getEntityArns()) != null) {
                jsonGenerator.writeFieldName("entityArns");
                jsonGenerator.writeStartArray();
                for (String string : list5) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list4 = eventFilter.getEntityValues()) != null) {
                jsonGenerator.writeFieldName("entityValues");
                jsonGenerator.writeStartArray();
                for (String string : list4) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list3 = eventFilter.getEventTypeCategories()) != null) {
                jsonGenerator.writeFieldName("eventTypeCategories");
                jsonGenerator.writeStartArray();
                for (String string : list3) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = eventFilter.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Map<String, String> map : list2) {
                    if (map == null) continue;
                    jsonGenerator.writeStartObject();
                    for (Map.Entry<String, String> TagsListMapEntry : map.entrySet()) {
                        if (TagsListMapEntry.getValue() == null) continue;
                        jsonGenerator.writeFieldName(TagsListMapEntry.getKey());
                        jsonGenerator.writeValue(TagsListMapEntry.getValue());
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = eventFilter.getEventStatusCodes()) != null) {
                jsonGenerator.writeFieldName("eventStatusCodes");
                jsonGenerator.writeStartArray();
                for (String eventStatusCodesListValue : list) {
                    if (eventStatusCodesListValue == null) continue;
                    jsonGenerator.writeValue(eventStatusCodesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventFilterJsonMarshaller();
        }
        return instance;
    }
}

