/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.Event;

public class EventJsonMarshaller {
    private static EventJsonMarshaller instance;

    public void marshall(Event event, StructuredJsonGenerator jsonGenerator) {
        if (event == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (event.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(event.getArn());
            }
            if (event.getService() != null) {
                jsonGenerator.writeFieldName("service").writeValue(event.getService());
            }
            if (event.getEventTypeCode() != null) {
                jsonGenerator.writeFieldName("eventTypeCode").writeValue(event.getEventTypeCode());
            }
            if (event.getEventTypeCategory() != null) {
                jsonGenerator.writeFieldName("eventTypeCategory").writeValue(event.getEventTypeCategory());
            }
            if (event.getRegion() != null) {
                jsonGenerator.writeFieldName("region").writeValue(event.getRegion());
            }
            if (event.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("availabilityZone").writeValue(event.getAvailabilityZone());
            }
            if (event.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(event.getStartTime());
            }
            if (event.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(event.getEndTime());
            }
            if (event.getLastUpdatedTime() != null) {
                jsonGenerator.writeFieldName("lastUpdatedTime").writeValue(event.getLastUpdatedTime());
            }
            if (event.getStatusCode() != null) {
                jsonGenerator.writeFieldName("statusCode").writeValue(event.getStatusCode());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventJsonMarshaller();
        }
        return instance;
    }
}

