/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.SecurityContext;
import com.amazonaws.services.guardduty.model.VolumeMount;
import com.amazonaws.services.guardduty.model.transform.ContainerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Container
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerRuntime;
    private String id;
    private String name;
    private String image;
    private String imagePrefix;
    private List<VolumeMount> volumeMounts;
    private SecurityContext securityContext;

    public void setContainerRuntime(String containerRuntime) {
        this.containerRuntime = containerRuntime;
    }

    public String getContainerRuntime() {
        return this.containerRuntime;
    }

    public Container withContainerRuntime(String containerRuntime) {
        this.setContainerRuntime(containerRuntime);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Container withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Container withName(String name) {
        this.setName(name);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public Container withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setImagePrefix(String imagePrefix) {
        this.imagePrefix = imagePrefix;
    }

    public String getImagePrefix() {
        return this.imagePrefix;
    }

    public Container withImagePrefix(String imagePrefix) {
        this.setImagePrefix(imagePrefix);
        return this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(Collection<VolumeMount> volumeMounts) {
        if (volumeMounts == null) {
            this.volumeMounts = null;
            return;
        }
        this.volumeMounts = new ArrayList<VolumeMount>(volumeMounts);
    }

    public Container withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts == null) {
            this.setVolumeMounts(new ArrayList<VolumeMount>(volumeMounts.length));
        }
        for (VolumeMount ele : volumeMounts) {
            this.volumeMounts.add(ele);
        }
        return this;
    }

    public Container withVolumeMounts(Collection<VolumeMount> volumeMounts) {
        this.setVolumeMounts(volumeMounts);
        return this;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public Container withSecurityContext(SecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerRuntime() != null) {
            sb.append("ContainerRuntime: ").append(this.getContainerRuntime()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getImagePrefix() != null) {
            sb.append("ImagePrefix: ").append(this.getImagePrefix()).append(",");
        }
        if (this.getVolumeMounts() != null) {
            sb.append("VolumeMounts: ").append(this.getVolumeMounts()).append(",");
        }
        if (this.getSecurityContext() != null) {
            sb.append("SecurityContext: ").append(this.getSecurityContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        if (other.getContainerRuntime() == null ^ this.getContainerRuntime() == null) {
            return false;
        }
        if (other.getContainerRuntime() != null && !other.getContainerRuntime().equals(this.getContainerRuntime())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getImagePrefix() == null ^ this.getImagePrefix() == null) {
            return false;
        }
        if (other.getImagePrefix() != null && !other.getImagePrefix().equals(this.getImagePrefix())) {
            return false;
        }
        if (other.getVolumeMounts() == null ^ this.getVolumeMounts() == null) {
            return false;
        }
        if (other.getVolumeMounts() != null && !other.getVolumeMounts().equals(this.getVolumeMounts())) {
            return false;
        }
        if (other.getSecurityContext() == null ^ this.getSecurityContext() == null) {
            return false;
        }
        return other.getSecurityContext() == null || other.getSecurityContext().equals(this.getSecurityContext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerRuntime() == null ? 0 : this.getContainerRuntime().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getImagePrefix() == null ? 0 : this.getImagePrefix().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeMounts() == null ? 0 : this.getVolumeMounts().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityContext() == null ? 0 : this.getSecurityContext().hashCode());
        return hashCode;
    }

    public Container clone() {
        try {
            return (Container)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

