/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.OrgFeature;
import com.amazonaws.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfiguration;
import com.amazonaws.services.guardduty.model.transform.OrganizationFeatureStatisticsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OrganizationFeatureStatistics
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Integer enabledAccountsCount;
    private List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OrganizationFeatureStatistics withName(String name) {
        this.setName(name);
        return this;
    }

    public OrganizationFeatureStatistics withName(OrgFeature name) {
        this.name = name.toString();
        return this;
    }

    public void setEnabledAccountsCount(Integer enabledAccountsCount) {
        this.enabledAccountsCount = enabledAccountsCount;
    }

    public Integer getEnabledAccountsCount() {
        return this.enabledAccountsCount;
    }

    public OrganizationFeatureStatistics withEnabledAccountsCount(Integer enabledAccountsCount) {
        this.setEnabledAccountsCount(enabledAccountsCount);
        return this;
    }

    public List<OrganizationFeatureStatisticsAdditionalConfiguration> getAdditionalConfiguration() {
        return this.additionalConfiguration;
    }

    public void setAdditionalConfiguration(Collection<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration) {
        if (additionalConfiguration == null) {
            this.additionalConfiguration = null;
            return;
        }
        this.additionalConfiguration = new ArrayList<OrganizationFeatureStatisticsAdditionalConfiguration>(additionalConfiguration);
    }

    public OrganizationFeatureStatistics withAdditionalConfiguration(OrganizationFeatureStatisticsAdditionalConfiguration ... additionalConfiguration) {
        if (this.additionalConfiguration == null) {
            this.setAdditionalConfiguration(new ArrayList<OrganizationFeatureStatisticsAdditionalConfiguration>(additionalConfiguration.length));
        }
        for (OrganizationFeatureStatisticsAdditionalConfiguration ele : additionalConfiguration) {
            this.additionalConfiguration.add(ele);
        }
        return this;
    }

    public OrganizationFeatureStatistics withAdditionalConfiguration(Collection<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration) {
        this.setAdditionalConfiguration(additionalConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getEnabledAccountsCount() != null) {
            sb.append("EnabledAccountsCount: ").append(this.getEnabledAccountsCount()).append(",");
        }
        if (this.getAdditionalConfiguration() != null) {
            sb.append("AdditionalConfiguration: ").append(this.getAdditionalConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureStatistics)) {
            return false;
        }
        OrganizationFeatureStatistics other = (OrganizationFeatureStatistics)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getEnabledAccountsCount() == null ^ this.getEnabledAccountsCount() == null) {
            return false;
        }
        if (other.getEnabledAccountsCount() != null && !other.getEnabledAccountsCount().equals(this.getEnabledAccountsCount())) {
            return false;
        }
        if (other.getAdditionalConfiguration() == null ^ this.getAdditionalConfiguration() == null) {
            return false;
        }
        return other.getAdditionalConfiguration() == null || other.getAdditionalConfiguration().equals(this.getAdditionalConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledAccountsCount() == null ? 0 : this.getEnabledAccountsCount().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalConfiguration() == null ? 0 : this.getAdditionalConfiguration().hashCode());
        return hashCode;
    }

    public OrganizationFeatureStatistics clone() {
        try {
            return (OrganizationFeatureStatistics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrganizationFeatureStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

