/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.UsageFeature;
import com.amazonaws.services.guardduty.model.UsageTopAccountResult;
import com.amazonaws.services.guardduty.model.transform.UsageTopAccountsResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UsageTopAccountsResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String feature;
    private List<UsageTopAccountResult> accounts;

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public UsageTopAccountsResult withFeature(String feature) {
        this.setFeature(feature);
        return this;
    }

    public UsageTopAccountsResult withFeature(UsageFeature feature) {
        this.feature = feature.toString();
        return this;
    }

    public List<UsageTopAccountResult> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<UsageTopAccountResult> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new ArrayList<UsageTopAccountResult>(accounts);
    }

    public UsageTopAccountsResult withAccounts(UsageTopAccountResult ... accounts) {
        if (this.accounts == null) {
            this.setAccounts(new ArrayList<UsageTopAccountResult>(accounts.length));
        }
        for (UsageTopAccountResult ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    public UsageTopAccountsResult withAccounts(Collection<UsageTopAccountResult> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFeature() != null) {
            sb.append("Feature: ").append(this.getFeature()).append(",");
        }
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTopAccountsResult)) {
            return false;
        }
        UsageTopAccountsResult other = (UsageTopAccountsResult)obj;
        if (other.getFeature() == null ^ this.getFeature() == null) {
            return false;
        }
        if (other.getFeature() != null && !other.getFeature().equals(this.getFeature())) {
            return false;
        }
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        return other.getAccounts() == null || other.getAccounts().equals(this.getAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFeature() == null ? 0 : this.getFeature().hashCode());
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        return hashCode;
    }

    public UsageTopAccountsResult clone() {
        try {
            return (UsageTopAccountsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UsageTopAccountsResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

