/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeMalwareScansResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Contains information about malware scans.
     * </p>
     */
    private java.util.List<Scan> scans;
    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Contains information about malware scans.
     * </p>
     * 
     * @return Contains information about malware scans.
     */

    public java.util.List<Scan> getScans() {
        return scans;
    }

    /**
     * <p>
     * Contains information about malware scans.
     * </p>
     * 
     * @param scans
     *        Contains information about malware scans.
     */

    public void setScans(java.util.Collection<Scan> scans) {
        if (scans == null) {
            this.scans = null;
            return;
        }

        this.scans = new java.util.ArrayList<Scan>(scans);
    }

    /**
     * <p>
     * Contains information about malware scans.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setScans(java.util.Collection)} or {@link #withScans(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param scans
     *        Contains information about malware scans.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeMalwareScansResult withScans(Scan... scans) {
        if (this.scans == null) {
            setScans(new java.util.ArrayList<Scan>(scans.length));
        }
        for (Scan ele : scans) {
            this.scans.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Contains information about malware scans.
     * </p>
     * 
     * @param scans
     *        Contains information about malware scans.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeMalwareScansResult withScans(java.util.Collection<Scan> scans) {
        setScans(scans);
        return this;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @param nextToken
     *        The pagination parameter to be used on the next list operation to retrieve more items.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @param nextToken
     *        The pagination parameter to be used on the next list operation to retrieve more items.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeMalwareScansResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScans() != null)
            sb.append("Scans: ").append(getScans()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeMalwareScansResult == false)
            return false;
        DescribeMalwareScansResult other = (DescribeMalwareScansResult) obj;
        if (other.getScans() == null ^ this.getScans() == null)
            return false;
        if (other.getScans() != null && other.getScans().equals(this.getScans()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScans() == null) ? 0 : getScans().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeMalwareScansResult clone() {
        try {
            return (DescribeMalwareScansResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
