/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.Scan;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ScanMarshaller {
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectorId").build();
    private static final MarshallingInfo<String> ADMINDETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adminDetectorId").build();
    private static final MarshallingInfo<String> SCANID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanId").build();
    private static final MarshallingInfo<String> SCANSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanStatus").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReason").build();
    private static final MarshallingInfo<Date> SCANSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> SCANENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> TRIGGERDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerDetails").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceDetails").build();
    private static final MarshallingInfo<StructuredPojo> SCANRESULTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanResultDetails").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<Long> TOTALBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalBytes").build();
    private static final MarshallingInfo<Long> FILECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileCount").build();
    private static final MarshallingInfo<List> ATTACHEDVOLUMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedVolumes").build();
    private static final ScanMarshaller instance = new ScanMarshaller();

    public static ScanMarshaller getInstance() {
        return instance;
    }

    public void marshall(Scan scan, ProtocolMarshaller protocolMarshaller) {
        if (scan == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scan.getDetectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)scan.getAdminDetectorId(), ADMINDETECTORID_BINDING);
            protocolMarshaller.marshall((Object)scan.getScanId(), SCANID_BINDING);
            protocolMarshaller.marshall((Object)scan.getScanStatus(), SCANSTATUS_BINDING);
            protocolMarshaller.marshall((Object)scan.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)scan.getScanStartTime(), SCANSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)scan.getScanEndTime(), SCANENDTIME_BINDING);
            protocolMarshaller.marshall((Object)scan.getTriggerDetails(), TRIGGERDETAILS_BINDING);
            protocolMarshaller.marshall((Object)scan.getResourceDetails(), RESOURCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)scan.getScanResultDetails(), SCANRESULTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)scan.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)scan.getTotalBytes(), TOTALBYTES_BINDING);
            protocolMarshaller.marshall((Object)scan.getFileCount(), FILECOUNT_BINDING);
            protocolMarshaller.marshall(scan.getAttachedVolumes(), ATTACHEDVOLUMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

