/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.OEMEphemeris;

@SdkInternalApi
public class OEMEphemerisMarshaller {
    private static final MarshallingInfo<String> OEMDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oemData").build();
    private static final MarshallingInfo<StructuredPojo> S3OBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Object").build();
    private static final OEMEphemerisMarshaller instance = new OEMEphemerisMarshaller();

    public static OEMEphemerisMarshaller getInstance() {
        return instance;
    }

    public void marshall(OEMEphemeris oEMEphemeris, ProtocolMarshaller protocolMarshaller) {
        if (oEMEphemeris == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)oEMEphemeris.getOemData(), OEMDATA_BINDING);
            protocolMarshaller.marshall((Object)oEMEphemeris.getS3Object(), S3OBJECT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

