/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.TLEEphemeris;
import java.util.List;

@SdkInternalApi
public class TLEEphemerisMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3OBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Object").build();
    private static final MarshallingInfo<List> TLEDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tleData").build();
    private static final TLEEphemerisMarshaller instance = new TLEEphemerisMarshaller();

    public static TLEEphemerisMarshaller getInstance() {
        return instance;
    }

    public void marshall(TLEEphemeris tLEEphemeris, ProtocolMarshaller protocolMarshaller) {
        if (tLEEphemeris == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tLEEphemeris.getS3Object(), S3OBJECT_BINDING);
            protocolMarshaller.marshall(tLEEphemeris.getTleData(), TLEDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

