/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.ComponentVersion;
import com.amazonaws.services.groundstation.model.transform.AgentDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AgentDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String agentVersion;
    private List<ComponentVersion> componentVersions;
    private String instanceId;
    private String instanceType;
    private List<Integer> reservedCpuCores;

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public AgentDetails withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public List<ComponentVersion> getComponentVersions() {
        return this.componentVersions;
    }

    public void setComponentVersions(Collection<ComponentVersion> componentVersions) {
        if (componentVersions == null) {
            this.componentVersions = null;
            return;
        }
        this.componentVersions = new ArrayList<ComponentVersion>(componentVersions);
    }

    public AgentDetails withComponentVersions(ComponentVersion ... componentVersions) {
        if (this.componentVersions == null) {
            this.setComponentVersions(new ArrayList<ComponentVersion>(componentVersions.length));
        }
        for (ComponentVersion ele : componentVersions) {
            this.componentVersions.add(ele);
        }
        return this;
    }

    public AgentDetails withComponentVersions(Collection<ComponentVersion> componentVersions) {
        this.setComponentVersions(componentVersions);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public AgentDetails withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public AgentDetails withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public List<Integer> getReservedCpuCores() {
        return this.reservedCpuCores;
    }

    public void setReservedCpuCores(Collection<Integer> reservedCpuCores) {
        if (reservedCpuCores == null) {
            this.reservedCpuCores = null;
            return;
        }
        this.reservedCpuCores = new ArrayList<Integer>(reservedCpuCores);
    }

    public AgentDetails withReservedCpuCores(Integer ... reservedCpuCores) {
        if (this.reservedCpuCores == null) {
            this.setReservedCpuCores(new ArrayList<Integer>(reservedCpuCores.length));
        }
        for (Integer ele : reservedCpuCores) {
            this.reservedCpuCores.add(ele);
        }
        return this;
    }

    public AgentDetails withReservedCpuCores(Collection<Integer> reservedCpuCores) {
        this.setReservedCpuCores(reservedCpuCores);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: ").append(this.getAgentVersion()).append(",");
        }
        if (this.getComponentVersions() != null) {
            sb.append("ComponentVersions: ").append(this.getComponentVersions()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getReservedCpuCores() != null) {
            sb.append("ReservedCpuCores: ").append(this.getReservedCpuCores());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentDetails)) {
            return false;
        }
        AgentDetails other = (AgentDetails)obj;
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        if (other.getAgentVersion() != null && !other.getAgentVersion().equals(this.getAgentVersion())) {
            return false;
        }
        if (other.getComponentVersions() == null ^ this.getComponentVersions() == null) {
            return false;
        }
        if (other.getComponentVersions() != null && !other.getComponentVersions().equals(this.getComponentVersions())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getReservedCpuCores() == null ^ this.getReservedCpuCores() == null) {
            return false;
        }
        return other.getReservedCpuCores() == null || other.getReservedCpuCores().equals(this.getReservedCpuCores());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getComponentVersions() == null ? 0 : this.getComponentVersions().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getReservedCpuCores() == null ? 0 : this.getReservedCpuCores().hashCode());
        return hashCode;
    }

    public AgentDetails clone() {
        try {
            return (AgentDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

