/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrassv2.model.LambdaEventSource;
import com.amazonaws.services.greengrassv2.model.LambdaInputPayloadEncodingType;
import com.amazonaws.services.greengrassv2.model.LambdaLinuxProcessParams;
import com.amazonaws.services.greengrassv2.model.transform.LambdaExecutionParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaExecutionParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private List<LambdaEventSource> eventSources;
    private Integer maxQueueSize;
    private Integer maxInstancesCount;
    private Integer maxIdleTimeInSeconds;
    private Integer timeoutInSeconds;
    private Integer statusTimeoutInSeconds;
    private Boolean pinned;
    private String inputPayloadEncodingType;
    private List<String> execArgs;
    private Map<String, String> environmentVariables;
    private LambdaLinuxProcessParams linuxProcessParams;

    public List<LambdaEventSource> getEventSources() {
        return this.eventSources;
    }

    public void setEventSources(Collection<LambdaEventSource> eventSources) {
        if (eventSources == null) {
            this.eventSources = null;
            return;
        }
        this.eventSources = new ArrayList<LambdaEventSource>(eventSources);
    }

    public LambdaExecutionParameters withEventSources(LambdaEventSource ... eventSources) {
        if (this.eventSources == null) {
            this.setEventSources(new ArrayList<LambdaEventSource>(eventSources.length));
        }
        for (LambdaEventSource ele : eventSources) {
            this.eventSources.add(ele);
        }
        return this;
    }

    public LambdaExecutionParameters withEventSources(Collection<LambdaEventSource> eventSources) {
        this.setEventSources(eventSources);
        return this;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public LambdaExecutionParameters withMaxQueueSize(Integer maxQueueSize) {
        this.setMaxQueueSize(maxQueueSize);
        return this;
    }

    public void setMaxInstancesCount(Integer maxInstancesCount) {
        this.maxInstancesCount = maxInstancesCount;
    }

    public Integer getMaxInstancesCount() {
        return this.maxInstancesCount;
    }

    public LambdaExecutionParameters withMaxInstancesCount(Integer maxInstancesCount) {
        this.setMaxInstancesCount(maxInstancesCount);
        return this;
    }

    public void setMaxIdleTimeInSeconds(Integer maxIdleTimeInSeconds) {
        this.maxIdleTimeInSeconds = maxIdleTimeInSeconds;
    }

    public Integer getMaxIdleTimeInSeconds() {
        return this.maxIdleTimeInSeconds;
    }

    public LambdaExecutionParameters withMaxIdleTimeInSeconds(Integer maxIdleTimeInSeconds) {
        this.setMaxIdleTimeInSeconds(maxIdleTimeInSeconds);
        return this;
    }

    public void setTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public LambdaExecutionParameters withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.setTimeoutInSeconds(timeoutInSeconds);
        return this;
    }

    public void setStatusTimeoutInSeconds(Integer statusTimeoutInSeconds) {
        this.statusTimeoutInSeconds = statusTimeoutInSeconds;
    }

    public Integer getStatusTimeoutInSeconds() {
        return this.statusTimeoutInSeconds;
    }

    public LambdaExecutionParameters withStatusTimeoutInSeconds(Integer statusTimeoutInSeconds) {
        this.setStatusTimeoutInSeconds(statusTimeoutInSeconds);
        return this;
    }

    public void setPinned(Boolean pinned) {
        this.pinned = pinned;
    }

    public Boolean getPinned() {
        return this.pinned;
    }

    public LambdaExecutionParameters withPinned(Boolean pinned) {
        this.setPinned(pinned);
        return this;
    }

    public Boolean isPinned() {
        return this.pinned;
    }

    public void setInputPayloadEncodingType(String inputPayloadEncodingType) {
        this.inputPayloadEncodingType = inputPayloadEncodingType;
    }

    public String getInputPayloadEncodingType() {
        return this.inputPayloadEncodingType;
    }

    public LambdaExecutionParameters withInputPayloadEncodingType(String inputPayloadEncodingType) {
        this.setInputPayloadEncodingType(inputPayloadEncodingType);
        return this;
    }

    public LambdaExecutionParameters withInputPayloadEncodingType(LambdaInputPayloadEncodingType inputPayloadEncodingType) {
        this.inputPayloadEncodingType = inputPayloadEncodingType.toString();
        return this;
    }

    public List<String> getExecArgs() {
        return this.execArgs;
    }

    public void setExecArgs(Collection<String> execArgs) {
        if (execArgs == null) {
            this.execArgs = null;
            return;
        }
        this.execArgs = new ArrayList<String>(execArgs);
    }

    public LambdaExecutionParameters withExecArgs(String ... execArgs) {
        if (this.execArgs == null) {
            this.setExecArgs(new ArrayList<String>(execArgs.length));
        }
        for (String ele : execArgs) {
            this.execArgs.add(ele);
        }
        return this;
    }

    public LambdaExecutionParameters withExecArgs(Collection<String> execArgs) {
        this.setExecArgs(execArgs);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public LambdaExecutionParameters withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public LambdaExecutionParameters addEnvironmentVariablesEntry(String key, String value) {
        if (null == this.environmentVariables) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environmentVariables.put(key, value);
        return this;
    }

    public LambdaExecutionParameters clearEnvironmentVariablesEntries() {
        this.environmentVariables = null;
        return this;
    }

    public void setLinuxProcessParams(LambdaLinuxProcessParams linuxProcessParams) {
        this.linuxProcessParams = linuxProcessParams;
    }

    public LambdaLinuxProcessParams getLinuxProcessParams() {
        return this.linuxProcessParams;
    }

    public LambdaExecutionParameters withLinuxProcessParams(LambdaLinuxProcessParams linuxProcessParams) {
        this.setLinuxProcessParams(linuxProcessParams);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventSources() != null) {
            sb.append("EventSources: ").append(this.getEventSources()).append(",");
        }
        if (this.getMaxQueueSize() != null) {
            sb.append("MaxQueueSize: ").append(this.getMaxQueueSize()).append(",");
        }
        if (this.getMaxInstancesCount() != null) {
            sb.append("MaxInstancesCount: ").append(this.getMaxInstancesCount()).append(",");
        }
        if (this.getMaxIdleTimeInSeconds() != null) {
            sb.append("MaxIdleTimeInSeconds: ").append(this.getMaxIdleTimeInSeconds()).append(",");
        }
        if (this.getTimeoutInSeconds() != null) {
            sb.append("TimeoutInSeconds: ").append(this.getTimeoutInSeconds()).append(",");
        }
        if (this.getStatusTimeoutInSeconds() != null) {
            sb.append("StatusTimeoutInSeconds: ").append(this.getStatusTimeoutInSeconds()).append(",");
        }
        if (this.getPinned() != null) {
            sb.append("Pinned: ").append(this.getPinned()).append(",");
        }
        if (this.getInputPayloadEncodingType() != null) {
            sb.append("InputPayloadEncodingType: ").append(this.getInputPayloadEncodingType()).append(",");
        }
        if (this.getExecArgs() != null) {
            sb.append("ExecArgs: ").append(this.getExecArgs()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables()).append(",");
        }
        if (this.getLinuxProcessParams() != null) {
            sb.append("LinuxProcessParams: ").append(this.getLinuxProcessParams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaExecutionParameters)) {
            return false;
        }
        LambdaExecutionParameters other = (LambdaExecutionParameters)obj;
        if (other.getEventSources() == null ^ this.getEventSources() == null) {
            return false;
        }
        if (other.getEventSources() != null && !other.getEventSources().equals(this.getEventSources())) {
            return false;
        }
        if (other.getMaxQueueSize() == null ^ this.getMaxQueueSize() == null) {
            return false;
        }
        if (other.getMaxQueueSize() != null && !other.getMaxQueueSize().equals(this.getMaxQueueSize())) {
            return false;
        }
        if (other.getMaxInstancesCount() == null ^ this.getMaxInstancesCount() == null) {
            return false;
        }
        if (other.getMaxInstancesCount() != null && !other.getMaxInstancesCount().equals(this.getMaxInstancesCount())) {
            return false;
        }
        if (other.getMaxIdleTimeInSeconds() == null ^ this.getMaxIdleTimeInSeconds() == null) {
            return false;
        }
        if (other.getMaxIdleTimeInSeconds() != null && !other.getMaxIdleTimeInSeconds().equals(this.getMaxIdleTimeInSeconds())) {
            return false;
        }
        if (other.getTimeoutInSeconds() == null ^ this.getTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getTimeoutInSeconds() != null && !other.getTimeoutInSeconds().equals(this.getTimeoutInSeconds())) {
            return false;
        }
        if (other.getStatusTimeoutInSeconds() == null ^ this.getStatusTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getStatusTimeoutInSeconds() != null && !other.getStatusTimeoutInSeconds().equals(this.getStatusTimeoutInSeconds())) {
            return false;
        }
        if (other.getPinned() == null ^ this.getPinned() == null) {
            return false;
        }
        if (other.getPinned() != null && !other.getPinned().equals(this.getPinned())) {
            return false;
        }
        if (other.getInputPayloadEncodingType() == null ^ this.getInputPayloadEncodingType() == null) {
            return false;
        }
        if (other.getInputPayloadEncodingType() != null && !other.getInputPayloadEncodingType().equals(this.getInputPayloadEncodingType())) {
            return false;
        }
        if (other.getExecArgs() == null ^ this.getExecArgs() == null) {
            return false;
        }
        if (other.getExecArgs() != null && !other.getExecArgs().equals(this.getExecArgs())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        if (other.getEnvironmentVariables() != null && !other.getEnvironmentVariables().equals(this.getEnvironmentVariables())) {
            return false;
        }
        if (other.getLinuxProcessParams() == null ^ this.getLinuxProcessParams() == null) {
            return false;
        }
        return other.getLinuxProcessParams() == null || other.getLinuxProcessParams().equals(this.getLinuxProcessParams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventSources() == null ? 0 : this.getEventSources().hashCode());
        hashCode = 31 * hashCode + (this.getMaxQueueSize() == null ? 0 : this.getMaxQueueSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaxInstancesCount() == null ? 0 : this.getMaxInstancesCount().hashCode());
        hashCode = 31 * hashCode + (this.getMaxIdleTimeInSeconds() == null ? 0 : this.getMaxIdleTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInSeconds() == null ? 0 : this.getTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getStatusTimeoutInSeconds() == null ? 0 : this.getStatusTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getPinned() == null ? 0 : this.getPinned().hashCode());
        hashCode = 31 * hashCode + (this.getInputPayloadEncodingType() == null ? 0 : this.getInputPayloadEncodingType().hashCode());
        hashCode = 31 * hashCode + (this.getExecArgs() == null ? 0 : this.getExecArgs().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getLinuxProcessParams() == null ? 0 : this.getLinuxProcessParams().hashCode());
        return hashCode;
    }

    public LambdaExecutionParameters clone() {
        try {
            return (LambdaExecutionParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaExecutionParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

