/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.greengrassv2.model.ComponentDeploymentSpecification;
import com.amazonaws.services.greengrassv2.model.DeploymentIoTJobConfiguration;
import com.amazonaws.services.greengrassv2.model.DeploymentPolicies;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateDeploymentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetArn;
    private String deploymentName;
    private Map<String, ComponentDeploymentSpecification> components;
    private DeploymentIoTJobConfiguration iotJobConfiguration;
    private DeploymentPolicies deploymentPolicies;
    private Map<String, String> tags;

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public CreateDeploymentRequest withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CreateDeploymentRequest withDeploymentName(String deploymentName) {
        this.setDeploymentName(deploymentName);
        return this;
    }

    public Map<String, ComponentDeploymentSpecification> getComponents() {
        return this.components;
    }

    public void setComponents(Map<String, ComponentDeploymentSpecification> components) {
        this.components = components;
    }

    public CreateDeploymentRequest withComponents(Map<String, ComponentDeploymentSpecification> components) {
        this.setComponents(components);
        return this;
    }

    public CreateDeploymentRequest addComponentsEntry(String key, ComponentDeploymentSpecification value) {
        if (null == this.components) {
            this.components = new HashMap<String, ComponentDeploymentSpecification>();
        }
        if (this.components.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.components.put(key, value);
        return this;
    }

    public CreateDeploymentRequest clearComponentsEntries() {
        this.components = null;
        return this;
    }

    public void setIotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration) {
        this.iotJobConfiguration = iotJobConfiguration;
    }

    public DeploymentIoTJobConfiguration getIotJobConfiguration() {
        return this.iotJobConfiguration;
    }

    public CreateDeploymentRequest withIotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration) {
        this.setIotJobConfiguration(iotJobConfiguration);
        return this;
    }

    public void setDeploymentPolicies(DeploymentPolicies deploymentPolicies) {
        this.deploymentPolicies = deploymentPolicies;
    }

    public DeploymentPolicies getDeploymentPolicies() {
        return this.deploymentPolicies;
    }

    public CreateDeploymentRequest withDeploymentPolicies(DeploymentPolicies deploymentPolicies) {
        this.setDeploymentPolicies(deploymentPolicies);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateDeploymentRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateDeploymentRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateDeploymentRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getDeploymentName() != null) {
            sb.append("DeploymentName: ").append(this.getDeploymentName()).append(",");
        }
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents()).append(",");
        }
        if (this.getIotJobConfiguration() != null) {
            sb.append("IotJobConfiguration: ").append(this.getIotJobConfiguration()).append(",");
        }
        if (this.getDeploymentPolicies() != null) {
            sb.append("DeploymentPolicies: ").append(this.getDeploymentPolicies()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)obj;
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getDeploymentName() == null ^ this.getDeploymentName() == null) {
            return false;
        }
        if (other.getDeploymentName() != null && !other.getDeploymentName().equals(this.getDeploymentName())) {
            return false;
        }
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        if (other.getComponents() != null && !other.getComponents().equals(this.getComponents())) {
            return false;
        }
        if (other.getIotJobConfiguration() == null ^ this.getIotJobConfiguration() == null) {
            return false;
        }
        if (other.getIotJobConfiguration() != null && !other.getIotJobConfiguration().equals(this.getIotJobConfiguration())) {
            return false;
        }
        if (other.getDeploymentPolicies() == null ^ this.getDeploymentPolicies() == null) {
            return false;
        }
        if (other.getDeploymentPolicies() != null && !other.getDeploymentPolicies().equals(this.getDeploymentPolicies())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentName() == null ? 0 : this.getDeploymentName().hashCode());
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        hashCode = 31 * hashCode + (this.getIotJobConfiguration() == null ? 0 : this.getIotJobConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentPolicies() == null ? 0 : this.getDeploymentPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateDeploymentRequest clone() {
        return (CreateDeploymentRequest)super.clone();
    }
}

