/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrassv2.model.CloudComponentState;
import com.amazonaws.services.greengrassv2.model.transform.CloudComponentStatusMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CloudComponentStatus
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentState;
    private String message;
    private Map<String, String> errors;

    public void setComponentState(String componentState) {
        this.componentState = componentState;
    }

    public String getComponentState() {
        return this.componentState;
    }

    public CloudComponentStatus withComponentState(String componentState) {
        this.setComponentState(componentState);
        return this;
    }

    public CloudComponentStatus withComponentState(CloudComponentState componentState) {
        this.componentState = componentState.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public CloudComponentStatus withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, String> errors) {
        this.errors = errors;
    }

    public CloudComponentStatus withErrors(Map<String, String> errors) {
        this.setErrors(errors);
        return this;
    }

    public CloudComponentStatus addErrorsEntry(String key, String value) {
        if (null == this.errors) {
            this.errors = new HashMap<String, String>();
        }
        if (this.errors.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.errors.put(key, value);
        return this;
    }

    public CloudComponentStatus clearErrorsEntries() {
        this.errors = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentState() != null) {
            sb.append("ComponentState: ").append(this.getComponentState()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudComponentStatus)) {
            return false;
        }
        CloudComponentStatus other = (CloudComponentStatus)obj;
        if (other.getComponentState() == null ^ this.getComponentState() == null) {
            return false;
        }
        if (other.getComponentState() != null && !other.getComponentState().equals(this.getComponentState())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentState() == null ? 0 : this.getComponentState().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public CloudComponentStatus clone() {
        try {
            return (CloudComponentStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudComponentStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

