/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.greengrassv2.AWSGreengrassV2Async;
import com.amazonaws.services.greengrassv2.AWSGreengrassV2AsyncClientBuilder;
import com.amazonaws.services.greengrassv2.AWSGreengrassV2Client;
import com.amazonaws.services.greengrassv2.model.CancelDeploymentRequest;
import com.amazonaws.services.greengrassv2.model.CancelDeploymentResult;
import com.amazonaws.services.greengrassv2.model.CreateComponentVersionRequest;
import com.amazonaws.services.greengrassv2.model.CreateComponentVersionResult;
import com.amazonaws.services.greengrassv2.model.CreateDeploymentRequest;
import com.amazonaws.services.greengrassv2.model.CreateDeploymentResult;
import com.amazonaws.services.greengrassv2.model.DeleteComponentRequest;
import com.amazonaws.services.greengrassv2.model.DeleteComponentResult;
import com.amazonaws.services.greengrassv2.model.DeleteCoreDeviceRequest;
import com.amazonaws.services.greengrassv2.model.DeleteCoreDeviceResult;
import com.amazonaws.services.greengrassv2.model.DescribeComponentRequest;
import com.amazonaws.services.greengrassv2.model.DescribeComponentResult;
import com.amazonaws.services.greengrassv2.model.GetComponentRequest;
import com.amazonaws.services.greengrassv2.model.GetComponentResult;
import com.amazonaws.services.greengrassv2.model.GetComponentVersionArtifactRequest;
import com.amazonaws.services.greengrassv2.model.GetComponentVersionArtifactResult;
import com.amazonaws.services.greengrassv2.model.GetCoreDeviceRequest;
import com.amazonaws.services.greengrassv2.model.GetCoreDeviceResult;
import com.amazonaws.services.greengrassv2.model.GetDeploymentRequest;
import com.amazonaws.services.greengrassv2.model.GetDeploymentResult;
import com.amazonaws.services.greengrassv2.model.ListComponentVersionsRequest;
import com.amazonaws.services.greengrassv2.model.ListComponentVersionsResult;
import com.amazonaws.services.greengrassv2.model.ListComponentsRequest;
import com.amazonaws.services.greengrassv2.model.ListComponentsResult;
import com.amazonaws.services.greengrassv2.model.ListCoreDevicesRequest;
import com.amazonaws.services.greengrassv2.model.ListCoreDevicesResult;
import com.amazonaws.services.greengrassv2.model.ListDeploymentsRequest;
import com.amazonaws.services.greengrassv2.model.ListDeploymentsResult;
import com.amazonaws.services.greengrassv2.model.ListEffectiveDeploymentsRequest;
import com.amazonaws.services.greengrassv2.model.ListEffectiveDeploymentsResult;
import com.amazonaws.services.greengrassv2.model.ListInstalledComponentsRequest;
import com.amazonaws.services.greengrassv2.model.ListInstalledComponentsResult;
import com.amazonaws.services.greengrassv2.model.ListTagsForResourceRequest;
import com.amazonaws.services.greengrassv2.model.ListTagsForResourceResult;
import com.amazonaws.services.greengrassv2.model.ResolveComponentCandidatesRequest;
import com.amazonaws.services.greengrassv2.model.ResolveComponentCandidatesResult;
import com.amazonaws.services.greengrassv2.model.TagResourceRequest;
import com.amazonaws.services.greengrassv2.model.TagResourceResult;
import com.amazonaws.services.greengrassv2.model.UntagResourceRequest;
import com.amazonaws.services.greengrassv2.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSGreengrassV2AsyncClient
extends AWSGreengrassV2Client
implements AWSGreengrassV2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSGreengrassV2AsyncClientBuilder asyncBuilder() {
        return AWSGreengrassV2AsyncClientBuilder.standard();
    }

    AWSGreengrassV2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSGreengrassV2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelDeploymentResult> cancelDeploymentAsync(CancelDeploymentRequest request) {
        return this.cancelDeploymentAsync(request, null);
    }

    @Override
    public Future<CancelDeploymentResult> cancelDeploymentAsync(CancelDeploymentRequest request, final AsyncHandler<CancelDeploymentRequest, CancelDeploymentResult> asyncHandler) {
        final CancelDeploymentRequest finalRequest = (CancelDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelDeploymentResult>(){

            @Override
            public CancelDeploymentResult call() throws Exception {
                CancelDeploymentResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeCancelDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateComponentVersionResult> createComponentVersionAsync(CreateComponentVersionRequest request) {
        return this.createComponentVersionAsync(request, null);
    }

    @Override
    public Future<CreateComponentVersionResult> createComponentVersionAsync(CreateComponentVersionRequest request, final AsyncHandler<CreateComponentVersionRequest, CreateComponentVersionResult> asyncHandler) {
        final CreateComponentVersionRequest finalRequest = (CreateComponentVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateComponentVersionResult>(){

            @Override
            public CreateComponentVersionResult call() throws Exception {
                CreateComponentVersionResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeCreateComponentVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request) {
        return this.createDeploymentAsync(request, null);
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request, final AsyncHandler<CreateDeploymentRequest, CreateDeploymentResult> asyncHandler) {
        final CreateDeploymentRequest finalRequest = (CreateDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDeploymentResult>(){

            @Override
            public CreateDeploymentResult call() throws Exception {
                CreateDeploymentResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeCreateDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteComponentResult> deleteComponentAsync(DeleteComponentRequest request) {
        return this.deleteComponentAsync(request, null);
    }

    @Override
    public Future<DeleteComponentResult> deleteComponentAsync(DeleteComponentRequest request, final AsyncHandler<DeleteComponentRequest, DeleteComponentResult> asyncHandler) {
        final DeleteComponentRequest finalRequest = (DeleteComponentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteComponentResult>(){

            @Override
            public DeleteComponentResult call() throws Exception {
                DeleteComponentResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeDeleteComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCoreDeviceResult> deleteCoreDeviceAsync(DeleteCoreDeviceRequest request) {
        return this.deleteCoreDeviceAsync(request, null);
    }

    @Override
    public Future<DeleteCoreDeviceResult> deleteCoreDeviceAsync(DeleteCoreDeviceRequest request, final AsyncHandler<DeleteCoreDeviceRequest, DeleteCoreDeviceResult> asyncHandler) {
        final DeleteCoreDeviceRequest finalRequest = (DeleteCoreDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCoreDeviceResult>(){

            @Override
            public DeleteCoreDeviceResult call() throws Exception {
                DeleteCoreDeviceResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeDeleteCoreDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComponentResult> describeComponentAsync(DescribeComponentRequest request) {
        return this.describeComponentAsync(request, null);
    }

    @Override
    public Future<DescribeComponentResult> describeComponentAsync(DescribeComponentRequest request, final AsyncHandler<DescribeComponentRequest, DescribeComponentResult> asyncHandler) {
        final DescribeComponentRequest finalRequest = (DescribeComponentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComponentResult>(){

            @Override
            public DescribeComponentResult call() throws Exception {
                DescribeComponentResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeDescribeComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComponentResult> getComponentAsync(GetComponentRequest request) {
        return this.getComponentAsync(request, null);
    }

    @Override
    public Future<GetComponentResult> getComponentAsync(GetComponentRequest request, final AsyncHandler<GetComponentRequest, GetComponentResult> asyncHandler) {
        final GetComponentRequest finalRequest = (GetComponentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComponentResult>(){

            @Override
            public GetComponentResult call() throws Exception {
                GetComponentResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeGetComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComponentVersionArtifactResult> getComponentVersionArtifactAsync(GetComponentVersionArtifactRequest request) {
        return this.getComponentVersionArtifactAsync(request, null);
    }

    @Override
    public Future<GetComponentVersionArtifactResult> getComponentVersionArtifactAsync(GetComponentVersionArtifactRequest request, final AsyncHandler<GetComponentVersionArtifactRequest, GetComponentVersionArtifactResult> asyncHandler) {
        final GetComponentVersionArtifactRequest finalRequest = (GetComponentVersionArtifactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComponentVersionArtifactResult>(){

            @Override
            public GetComponentVersionArtifactResult call() throws Exception {
                GetComponentVersionArtifactResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeGetComponentVersionArtifact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCoreDeviceResult> getCoreDeviceAsync(GetCoreDeviceRequest request) {
        return this.getCoreDeviceAsync(request, null);
    }

    @Override
    public Future<GetCoreDeviceResult> getCoreDeviceAsync(GetCoreDeviceRequest request, final AsyncHandler<GetCoreDeviceRequest, GetCoreDeviceResult> asyncHandler) {
        final GetCoreDeviceRequest finalRequest = (GetCoreDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCoreDeviceResult>(){

            @Override
            public GetCoreDeviceResult call() throws Exception {
                GetCoreDeviceResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeGetCoreDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeploymentResult> getDeploymentAsync(GetDeploymentRequest request) {
        return this.getDeploymentAsync(request, null);
    }

    @Override
    public Future<GetDeploymentResult> getDeploymentAsync(GetDeploymentRequest request, final AsyncHandler<GetDeploymentRequest, GetDeploymentResult> asyncHandler) {
        final GetDeploymentRequest finalRequest = (GetDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDeploymentResult>(){

            @Override
            public GetDeploymentResult call() throws Exception {
                GetDeploymentResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeGetDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListComponentVersionsResult> listComponentVersionsAsync(ListComponentVersionsRequest request) {
        return this.listComponentVersionsAsync(request, null);
    }

    @Override
    public Future<ListComponentVersionsResult> listComponentVersionsAsync(ListComponentVersionsRequest request, final AsyncHandler<ListComponentVersionsRequest, ListComponentVersionsResult> asyncHandler) {
        final ListComponentVersionsRequest finalRequest = (ListComponentVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListComponentVersionsResult>(){

            @Override
            public ListComponentVersionsResult call() throws Exception {
                ListComponentVersionsResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListComponentVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListComponentsResult> listComponentsAsync(ListComponentsRequest request) {
        return this.listComponentsAsync(request, null);
    }

    @Override
    public Future<ListComponentsResult> listComponentsAsync(ListComponentsRequest request, final AsyncHandler<ListComponentsRequest, ListComponentsResult> asyncHandler) {
        final ListComponentsRequest finalRequest = (ListComponentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListComponentsResult>(){

            @Override
            public ListComponentsResult call() throws Exception {
                ListComponentsResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListComponents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCoreDevicesResult> listCoreDevicesAsync(ListCoreDevicesRequest request) {
        return this.listCoreDevicesAsync(request, null);
    }

    @Override
    public Future<ListCoreDevicesResult> listCoreDevicesAsync(ListCoreDevicesRequest request, final AsyncHandler<ListCoreDevicesRequest, ListCoreDevicesResult> asyncHandler) {
        final ListCoreDevicesRequest finalRequest = (ListCoreDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCoreDevicesResult>(){

            @Override
            public ListCoreDevicesResult call() throws Exception {
                ListCoreDevicesResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListCoreDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request) {
        return this.listDeploymentsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request, final AsyncHandler<ListDeploymentsRequest, ListDeploymentsResult> asyncHandler) {
        final ListDeploymentsRequest finalRequest = (ListDeploymentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeploymentsResult>(){

            @Override
            public ListDeploymentsResult call() throws Exception {
                ListDeploymentsResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListDeployments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEffectiveDeploymentsResult> listEffectiveDeploymentsAsync(ListEffectiveDeploymentsRequest request) {
        return this.listEffectiveDeploymentsAsync(request, null);
    }

    @Override
    public Future<ListEffectiveDeploymentsResult> listEffectiveDeploymentsAsync(ListEffectiveDeploymentsRequest request, final AsyncHandler<ListEffectiveDeploymentsRequest, ListEffectiveDeploymentsResult> asyncHandler) {
        final ListEffectiveDeploymentsRequest finalRequest = (ListEffectiveDeploymentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEffectiveDeploymentsResult>(){

            @Override
            public ListEffectiveDeploymentsResult call() throws Exception {
                ListEffectiveDeploymentsResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListEffectiveDeployments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInstalledComponentsResult> listInstalledComponentsAsync(ListInstalledComponentsRequest request) {
        return this.listInstalledComponentsAsync(request, null);
    }

    @Override
    public Future<ListInstalledComponentsResult> listInstalledComponentsAsync(ListInstalledComponentsRequest request, final AsyncHandler<ListInstalledComponentsRequest, ListInstalledComponentsResult> asyncHandler) {
        final ListInstalledComponentsRequest finalRequest = (ListInstalledComponentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInstalledComponentsResult>(){

            @Override
            public ListInstalledComponentsResult call() throws Exception {
                ListInstalledComponentsResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListInstalledComponents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResolveComponentCandidatesResult> resolveComponentCandidatesAsync(ResolveComponentCandidatesRequest request) {
        return this.resolveComponentCandidatesAsync(request, null);
    }

    @Override
    public Future<ResolveComponentCandidatesResult> resolveComponentCandidatesAsync(ResolveComponentCandidatesRequest request, final AsyncHandler<ResolveComponentCandidatesRequest, ResolveComponentCandidatesResult> asyncHandler) {
        final ResolveComponentCandidatesRequest finalRequest = (ResolveComponentCandidatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResolveComponentCandidatesResult>(){

            @Override
            public ResolveComponentCandidatesResult call() throws Exception {
                ResolveComponentCandidatesResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeResolveComponentCandidates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSGreengrassV2AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

