/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.GlueSchema;
import com.amazonaws.services.glue.model.transform.CatalogDeltaSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CatalogDeltaSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String database;
    private String table;
    private Map<String, String> additionalDeltaOptions;
    private List<GlueSchema> outputSchemas;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CatalogDeltaSource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public CatalogDeltaSource withDatabase(String database) {
        this.setDatabase(database);
        return this;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public CatalogDeltaSource withTable(String table) {
        this.setTable(table);
        return this;
    }

    public Map<String, String> getAdditionalDeltaOptions() {
        return this.additionalDeltaOptions;
    }

    public void setAdditionalDeltaOptions(Map<String, String> additionalDeltaOptions) {
        this.additionalDeltaOptions = additionalDeltaOptions;
    }

    public CatalogDeltaSource withAdditionalDeltaOptions(Map<String, String> additionalDeltaOptions) {
        this.setAdditionalDeltaOptions(additionalDeltaOptions);
        return this;
    }

    public CatalogDeltaSource addAdditionalDeltaOptionsEntry(String key, String value) {
        if (null == this.additionalDeltaOptions) {
            this.additionalDeltaOptions = new HashMap<String, String>();
        }
        if (this.additionalDeltaOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalDeltaOptions.put(key, value);
        return this;
    }

    public CatalogDeltaSource clearAdditionalDeltaOptionsEntries() {
        this.additionalDeltaOptions = null;
        return this;
    }

    public List<GlueSchema> getOutputSchemas() {
        return this.outputSchemas;
    }

    public void setOutputSchemas(Collection<GlueSchema> outputSchemas) {
        if (outputSchemas == null) {
            this.outputSchemas = null;
            return;
        }
        this.outputSchemas = new ArrayList<GlueSchema>(outputSchemas);
    }

    public CatalogDeltaSource withOutputSchemas(GlueSchema ... outputSchemas) {
        if (this.outputSchemas == null) {
            this.setOutputSchemas(new ArrayList<GlueSchema>(outputSchemas.length));
        }
        for (GlueSchema ele : outputSchemas) {
            this.outputSchemas.add(ele);
        }
        return this;
    }

    public CatalogDeltaSource withOutputSchemas(Collection<GlueSchema> outputSchemas) {
        this.setOutputSchemas(outputSchemas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable()).append(",");
        }
        if (this.getAdditionalDeltaOptions() != null) {
            sb.append("AdditionalDeltaOptions: ").append(this.getAdditionalDeltaOptions()).append(",");
        }
        if (this.getOutputSchemas() != null) {
            sb.append("OutputSchemas: ").append(this.getOutputSchemas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogDeltaSource)) {
            return false;
        }
        CatalogDeltaSource other = (CatalogDeltaSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getAdditionalDeltaOptions() == null ^ this.getAdditionalDeltaOptions() == null) {
            return false;
        }
        if (other.getAdditionalDeltaOptions() != null && !other.getAdditionalDeltaOptions().equals(this.getAdditionalDeltaOptions())) {
            return false;
        }
        if (other.getOutputSchemas() == null ^ this.getOutputSchemas() == null) {
            return false;
        }
        return other.getOutputSchemas() == null || other.getOutputSchemas().equals(this.getOutputSchemas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalDeltaOptions() == null ? 0 : this.getAdditionalDeltaOptions().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSchemas() == null ? 0 : this.getOutputSchemas().hashCode());
        return hashCode;
    }

    public CatalogDeltaSource clone() {
        try {
            return (CatalogDeltaSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CatalogDeltaSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

