/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.CatalogTargetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CatalogTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String databaseName;
    private List<String> tables;
    private String connectionName;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CatalogTarget withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(Collection<String> tables) {
        if (tables == null) {
            this.tables = null;
            return;
        }
        this.tables = new ArrayList<String>(tables);
    }

    public CatalogTarget withTables(String ... tables) {
        if (this.tables == null) {
            this.setTables(new ArrayList<String>(tables.length));
        }
        for (String ele : tables) {
            this.tables.add(ele);
        }
        return this;
    }

    public CatalogTarget withTables(Collection<String> tables) {
        this.setTables(tables);
        return this;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public CatalogTarget withConnectionName(String connectionName) {
        this.setConnectionName(connectionName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getTables() != null) {
            sb.append("Tables: ").append(this.getTables()).append(",");
        }
        if (this.getConnectionName() != null) {
            sb.append("ConnectionName: ").append(this.getConnectionName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogTarget)) {
            return false;
        }
        CatalogTarget other = (CatalogTarget)obj;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getTables() == null ^ this.getTables() == null) {
            return false;
        }
        if (other.getTables() != null && !other.getTables().equals(this.getTables())) {
            return false;
        }
        if (other.getConnectionName() == null ^ this.getConnectionName() == null) {
            return false;
        }
        return other.getConnectionName() == null || other.getConnectionName().equals(this.getConnectionName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getTables() == null ? 0 : this.getTables().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionName() == null ? 0 : this.getConnectionName().hashCode());
        return hashCode;
    }

    public CatalogTarget clone() {
        try {
            return (CatalogTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CatalogTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

