/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.WorkflowGraph;
import com.amazonaws.services.glue.model.WorkflowRunStatistics;
import com.amazonaws.services.glue.model.WorkflowRunStatus;
import com.amazonaws.services.glue.model.transform.WorkflowRunMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkflowRun
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String workflowRunId;
    private String previousRunId;
    private Map<String, String> workflowRunProperties;
    private Date startedOn;
    private Date completedOn;
    private String status;
    private WorkflowRunStatistics statistics;
    private WorkflowGraph graph;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WorkflowRun withName(String name) {
        this.setName(name);
        return this;
    }

    public void setWorkflowRunId(String workflowRunId) {
        this.workflowRunId = workflowRunId;
    }

    public String getWorkflowRunId() {
        return this.workflowRunId;
    }

    public WorkflowRun withWorkflowRunId(String workflowRunId) {
        this.setWorkflowRunId(workflowRunId);
        return this;
    }

    public void setPreviousRunId(String previousRunId) {
        this.previousRunId = previousRunId;
    }

    public String getPreviousRunId() {
        return this.previousRunId;
    }

    public WorkflowRun withPreviousRunId(String previousRunId) {
        this.setPreviousRunId(previousRunId);
        return this;
    }

    public Map<String, String> getWorkflowRunProperties() {
        return this.workflowRunProperties;
    }

    public void setWorkflowRunProperties(Map<String, String> workflowRunProperties) {
        this.workflowRunProperties = workflowRunProperties;
    }

    public WorkflowRun withWorkflowRunProperties(Map<String, String> workflowRunProperties) {
        this.setWorkflowRunProperties(workflowRunProperties);
        return this;
    }

    public WorkflowRun addWorkflowRunPropertiesEntry(String key, String value) {
        if (null == this.workflowRunProperties) {
            this.workflowRunProperties = new HashMap<String, String>();
        }
        if (this.workflowRunProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.workflowRunProperties.put(key, value);
        return this;
    }

    public WorkflowRun clearWorkflowRunPropertiesEntries() {
        this.workflowRunProperties = null;
        return this;
    }

    public void setStartedOn(Date startedOn) {
        this.startedOn = startedOn;
    }

    public Date getStartedOn() {
        return this.startedOn;
    }

    public WorkflowRun withStartedOn(Date startedOn) {
        this.setStartedOn(startedOn);
        return this;
    }

    public void setCompletedOn(Date completedOn) {
        this.completedOn = completedOn;
    }

    public Date getCompletedOn() {
        return this.completedOn;
    }

    public WorkflowRun withCompletedOn(Date completedOn) {
        this.setCompletedOn(completedOn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public WorkflowRun withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public WorkflowRun withStatus(WorkflowRunStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatistics(WorkflowRunStatistics statistics) {
        this.statistics = statistics;
    }

    public WorkflowRunStatistics getStatistics() {
        return this.statistics;
    }

    public WorkflowRun withStatistics(WorkflowRunStatistics statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public void setGraph(WorkflowGraph graph) {
        this.graph = graph;
    }

    public WorkflowGraph getGraph() {
        return this.graph;
    }

    public WorkflowRun withGraph(WorkflowGraph graph) {
        this.setGraph(graph);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getWorkflowRunId() != null) {
            sb.append("WorkflowRunId: ").append(this.getWorkflowRunId()).append(",");
        }
        if (this.getPreviousRunId() != null) {
            sb.append("PreviousRunId: ").append(this.getPreviousRunId()).append(",");
        }
        if (this.getWorkflowRunProperties() != null) {
            sb.append("WorkflowRunProperties: ").append(this.getWorkflowRunProperties()).append(",");
        }
        if (this.getStartedOn() != null) {
            sb.append("StartedOn: ").append(this.getStartedOn()).append(",");
        }
        if (this.getCompletedOn() != null) {
            sb.append("CompletedOn: ").append(this.getCompletedOn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getGraph() != null) {
            sb.append("Graph: ").append(this.getGraph());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowRun)) {
            return false;
        }
        WorkflowRun other = (WorkflowRun)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getWorkflowRunId() == null ^ this.getWorkflowRunId() == null) {
            return false;
        }
        if (other.getWorkflowRunId() != null && !other.getWorkflowRunId().equals(this.getWorkflowRunId())) {
            return false;
        }
        if (other.getPreviousRunId() == null ^ this.getPreviousRunId() == null) {
            return false;
        }
        if (other.getPreviousRunId() != null && !other.getPreviousRunId().equals(this.getPreviousRunId())) {
            return false;
        }
        if (other.getWorkflowRunProperties() == null ^ this.getWorkflowRunProperties() == null) {
            return false;
        }
        if (other.getWorkflowRunProperties() != null && !other.getWorkflowRunProperties().equals(this.getWorkflowRunProperties())) {
            return false;
        }
        if (other.getStartedOn() == null ^ this.getStartedOn() == null) {
            return false;
        }
        if (other.getStartedOn() != null && !other.getStartedOn().equals(this.getStartedOn())) {
            return false;
        }
        if (other.getCompletedOn() == null ^ this.getCompletedOn() == null) {
            return false;
        }
        if (other.getCompletedOn() != null && !other.getCompletedOn().equals(this.getCompletedOn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getGraph() == null ^ this.getGraph() == null) {
            return false;
        }
        return other.getGraph() == null || other.getGraph().equals(this.getGraph());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowRunId() == null ? 0 : this.getWorkflowRunId().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousRunId() == null ? 0 : this.getPreviousRunId().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowRunProperties() == null ? 0 : this.getWorkflowRunProperties().hashCode());
        hashCode = 31 * hashCode + (this.getStartedOn() == null ? 0 : this.getStartedOn().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedOn() == null ? 0 : this.getCompletedOn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getGraph() == null ? 0 : this.getGraph().hashCode());
        return hashCode;
    }

    public WorkflowRun clone() {
        try {
            return (WorkflowRun)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowRunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

